import { Directive, Inject, Input, Optional, } from '@angular/core';
import { DynamicComponentInjectorToken, } from '../component-injector';
import { IoService } from '../io';
import * as i0 from "@angular/core";
import * as i1 from "../io";
/* eslint-disable @angular-eslint/no-conflicting-lifecycle */
export class DynamicIoDirective {
    constructor(ioService, componentInjector) {
        this.ioService = ioService;
        this.componentInjector = componentInjector;
        this.ioService.init(this.componentInjector);
    }
    get inputs() {
        return this.ndcDynamicInputs || this.ngComponentOutletNdcDynamicInputs;
    }
    get outputs() {
        return this.ndcDynamicOutputs || this.ngComponentOutletNdcDynamicOutputs;
    }
    ngOnChanges(changes) {
        this.ioService.update(this.inputs, this.outputs, this.inputsChanged(changes), this.outputsChanged(changes));
    }
    ngDoCheck() {
        this.ioService.maybeUpdate();
    }
    inputsChanged(changes) {
        return ('ngComponentOutletNdcDynamicInputs' in changes ||
            'ndcDynamicInputs' in changes);
    }
    outputsChanged(changes) {
        return ('ngComponentOutletNdcDynamicOutputs' in changes ||
            'ndcDynamicOutputs' in changes);
    }
}
/** @nocollapse */ /** @nocollapse */ DynamicIoDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoDirective, deps: [{ token: i1.IoService }, { token: DynamicComponentInjectorToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ /** @nocollapse */ DynamicIoDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.2", type: DynamicIoDirective, selector: "[ndcDynamicInputs],[ndcDynamicOutputs],[ngComponentOutletNdcDynamicInputs],[ngComponentOutletNdcDynamicOutputs]", inputs: { ndcDynamicInputs: "ndcDynamicInputs", ngComponentOutletNdcDynamicInputs: "ngComponentOutletNdcDynamicInputs", ndcDynamicOutputs: "ndcDynamicOutputs", ngComponentOutletNdcDynamicOutputs: "ngComponentOutletNdcDynamicOutputs" }, providers: [IoService], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ndcDynamicInputs],[ndcDynamicOutputs],[ngComponentOutletNdcDynamicInputs],[ngComponentOutletNdcDynamicOutputs]',
                    providers: [IoService],
                }]
        }], ctorParameters: function () { return [{ type: i1.IoService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { ndcDynamicInputs: [{
                type: Input
            }], ngComponentOutletNdcDynamicInputs: [{
                type: Input
            }], ndcDynamicOutputs: [{
                type: Input
            }], ngComponentOutletNdcDynamicOutputs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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