import { Component, EventEmitter, Injector, Input, Output, } from '@angular/core';
import { DynamicComponentInjectorToken, } from './component-injector';
import * as i0 from "@angular/core";
export class DynamicComponent {
    constructor(vcr) {
        this.vcr = vcr;
        this.ndcDynamicCreated = new EventEmitter();
        this.componentRef = null;
    }
    ngOnChanges(changes) {
        if (DynamicComponent.UpdateOnInputs.some((input) => changes.hasOwnProperty(input))) {
            this.createDynamicComponent();
        }
    }
    createDynamicComponent() {
        this.vcr.clear();
        this.componentRef = null;
        if (this.ndcDynamicComponent) {
            this.componentRef = this.vcr.createComponent(this.ndcDynamicComponent, {
                index: 0,
                injector: this._resolveInjector(),
                projectableNodes: this.ndcDynamicContent,
            });
            this.ndcDynamicCreated.emit(this.componentRef);
        }
    }
    _resolveInjector() {
        let injector = this.ndcDynamicInjector || this.vcr.injector;
        if (this.ndcDynamicProviders) {
            injector = Injector.create({
                providers: this.ndcDynamicProviders,
                parent: injector,
            });
        }
        return injector;
    }
}
DynamicComponent.UpdateOnInputs = [
    'ndcDynamicComponent',
    'ndcDynamicInjector',
    'ndcDynamicProviders',
    'ndcDynamicContent',
];
/** @nocollapse */ /** @nocollapse */ DynamicComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicComponent, deps: [{ token: i0.ViewContainerRef }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ /** @nocollapse */ DynamicComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "13.0.2", type: DynamicComponent, selector: "ndc-dynamic", inputs: { ndcDynamicComponent: "ndcDynamicComponent", ndcDynamicInjector: "ndcDynamicInjector", ndcDynamicProviders: "ndcDynamicProviders", ndcDynamicContent: "ndcDynamicContent" }, outputs: { ndcDynamicCreated: "ndcDynamicCreated" }, providers: [
        { provide: DynamicComponentInjectorToken, useExisting: DynamicComponent },
    ], usesOnChanges: true, ngImport: i0, template: '', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'ndc-dynamic',
                    template: '',
                    providers: [
                        { provide: DynamicComponentInjectorToken, useExisting: DynamicComponent },
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.ViewContainerRef }]; }, propDecorators: { ndcDynamicComponent: [{
                type: Input
            }], ndcDynamicInjector: [{
                type: Input
            }], ndcDynamicProviders: [{
                type: Input
            }], ndcDynamicContent: [{
                type: Input
            }], ndcDynamicCreated: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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