import { SimpleChange } from '@angular/core';
export function createNewChange(val) {
    return new SimpleChange(undefined, val, true);
}
export function createChange(val, prevVal) {
    return new SimpleChange(prevVal, val, false);
}
export function noop() { }
export function getCtorParamTypes(ctor, reflect) {
    return reflect.getMetadata('design:paramtypes', ctor);
}
/**
 * Extract type arguments from Angular Directive/Component
 */
export function extractNgParamTypes(type) {
    // NOTE: Accessing private APIs of Angular
    return type?.ctorParameters?.()?.map((param) => param.type);
}
//# sourceMappingURL=data:application/json;base64,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