import * as i0 from '@angular/core';
import { InjectionToken, Directive, Host, NgModule, SimpleChange, ChangeDetectorRef, Injectable, Inject, Optional, Input, EventEmitter, Injector, Component, Output, ElementRef } from '@angular/core';
import * as i1 from '@angular/common';
import { CommonModule } from '@angular/common';
import { Subject } from 'rxjs';
import { takeUntil } from 'rxjs/operators';

function defaultEventArgumentFactory() {
    return '$event';
}
const EventArgumentToken = new InjectionToken('EventArgument', {
    providedIn: 'root',
    factory: defaultEventArgumentFactory,
});

const DynamicComponentInjectorToken = new InjectionToken('DynamicComponentInjector');

class ComponentOutletInjectorDirective {
    constructor(componentOutlet) {
        this.componentOutlet = componentOutlet;
    }
    get componentRef() {
        // NOTE: Accessing private APIs of Angular
        return this.componentOutlet._componentRef;
    }
}
/** @nocollapse */ /** @nocollapse */ ComponentOutletInjectorDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: ComponentOutletInjectorDirective, deps: [{ token: i1.NgComponentOutlet, host: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ /** @nocollapse */ ComponentOutletInjectorDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.2", type: ComponentOutletInjectorDirective, selector: "[ngComponentOutlet]", providers: [
        {
            provide: DynamicComponentInjectorToken,
            useExisting: ComponentOutletInjectorDirective,
        },
    ], exportAs: ["ndcComponentOutletInjector"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: ComponentOutletInjectorDirective, decorators: [{
            type: Directive,
            args: [{
                    // eslint-disable-next-line @angular-eslint/directive-selector
                    selector: '[ngComponentOutlet]',
                    exportAs: 'ndcComponentOutletInjector',
                    providers: [
                        {
                            provide: DynamicComponentInjectorToken,
                            useExisting: ComponentOutletInjectorDirective,
                        },
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i1.NgComponentOutlet, decorators: [{
                    type: Host
                }] }]; } });

class ComponentOutletInjectorModule {
}
/** @nocollapse */ /** @nocollapse */ ComponentOutletInjectorModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: ComponentOutletInjectorModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ /** @nocollapse */ ComponentOutletInjectorModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: ComponentOutletInjectorModule, declarations: [ComponentOutletInjectorDirective], imports: [CommonModule], exports: [ComponentOutletInjectorDirective] });
/** @nocollapse */ /** @nocollapse */ ComponentOutletInjectorModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: ComponentOutletInjectorModule, imports: [[CommonModule]] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: ComponentOutletInjectorModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [CommonModule],
                    exports: [ComponentOutletInjectorDirective],
                    declarations: [ComponentOutletInjectorDirective],
                }]
        }] });

function createNewChange(val) {
    return new SimpleChange(undefined, val, true);
}
function createChange(val, prevVal) {
    return new SimpleChange(prevVal, val, false);
}
function noop() { }
function getCtorParamTypes(ctor, reflect) {
    return reflect.getMetadata('design:paramtypes', ctor);
}
/**
 * Extract type arguments from Angular Directive/Component
 */
function extractNgParamTypes(type) {
    // NOTE: Accessing private APIs of Angular
    return type?.ctorParameters?.()?.map((param) => param.type);
}

class IoService {
    constructor(differs, cfr, eventArgument, cdr) {
        this.differs = differs;
        this.cfr = cfr;
        this.eventArgument = eventArgument;
        this.cdr = cdr;
        this.checkInit = this.failInit;
        this.lastComponentInst = null;
        this.inputsDiffer = this.differs.find({}).create();
        this.compFactory = null;
        this.outputsShouldDisconnect$ = new Subject();
        this.outputsChanged = () => false;
    }
    get compRef() {
        return this.compInjector.componentRef;
    }
    get componentInst() {
        return this.compRef ? this.compRef.instance : null;
    }
    get componentInstChanged() {
        if (this.lastComponentInst !== this.componentInst) {
            this.lastComponentInst = this.componentInst;
            return true;
        }
        else {
            return false;
        }
    }
    get compCdr() {
        return this.compRef ? this.compRef.injector.get(ChangeDetectorRef) : null;
    }
    ngOnDestroy() {
        this._disconnectOutputs();
    }
    init(componentInjector, options = {}) {
        this.checkInit = componentInjector ? noop : this.failInit;
        this.compInjector = componentInjector;
        if (options.trackOutputChanges) {
            const outputsDiffer = this.differs.find({}).create();
            this.outputsChanged = (outputs) => !!outputsDiffer.diff(outputs);
        }
    }
    update(inputs, outputs, inputsChanged, outputsChanged) {
        this.checkInit();
        this.updateIO(inputs, outputs);
        const compChanged = this.componentInstChanged;
        if (compChanged || inputsChanged) {
            const inputsChanges = this._getInputsChanges();
            if (inputsChanges) {
                this._updateInputChanges(inputsChanges);
            }
            this.updateInputs(compChanged || !this.lastInputChanges);
        }
        if (compChanged || outputsChanged) {
            this.bindOutputs();
        }
    }
    maybeUpdate() {
        this.checkInit();
        if (this.componentInstChanged) {
            this.updateInputs(true);
            this.bindOutputs();
            return;
        }
        if (this.outputsChanged(this.outputs)) {
            this.bindOutputs();
        }
        if (!this.inputs) {
            return;
        }
        const inputsChanges = this._getInputsChanges();
        if (inputsChanges) {
            const isNotFirstChange = !!this.lastInputChanges;
            this._updateInputChanges(inputsChanges);
            if (isNotFirstChange) {
                this.updateInputs();
            }
        }
    }
    updateIO(inputs, outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }
    updateInputs(isFirstChange = false) {
        if (isFirstChange) {
            this._updateCompFactory();
        }
        const compInst = this.componentInst;
        let inputs = this.inputs;
        if (!inputs || !compInst) {
            return;
        }
        inputs = this._resolveInputs(inputs);
        Object.keys(inputs).forEach((p) => (compInst[p] = inputs[p]));
        // Mark component for check to re-render with new inputs
        if (this.compCdr) {
            this.compCdr.markForCheck();
        }
        this.notifyOnInputChanges(this.lastInputChanges, isFirstChange);
    }
    bindOutputs() {
        this._disconnectOutputs();
        const compInst = this.componentInst;
        let outputs = this.outputs;
        if (!outputs || !compInst) {
            return;
        }
        outputs = this._resolveOutputs(outputs);
        Object.keys(outputs)
            .filter((p) => compInst[p])
            .forEach((p) => compInst[p]
            .pipe(takeUntil(this.outputsShouldDisconnect$))
            .subscribe((event) => {
            this.cdr.markForCheck();
            return outputs[p](event);
        }));
    }
    notifyOnInputChanges(changes = {}, forceFirstChanges) {
        // Exit early if component not interested to receive changes
        if (!this.componentInst.ngOnChanges) {
            return;
        }
        if (forceFirstChanges) {
            changes = this._collectFirstChanges();
        }
        this.componentInst.ngOnChanges(changes);
    }
    _disconnectOutputs() {
        this.outputsShouldDisconnect$.next();
    }
    _getInputsChanges() {
        return this.inputsDiffer.diff(this.inputs);
    }
    _updateInputChanges(differ) {
        this.lastInputChanges = this._collectChangesFromDiffer(differ);
    }
    _collectFirstChanges() {
        const changes = {};
        const inputs = this.inputs;
        Object.keys(inputs).forEach((prop) => (changes[prop] = createNewChange(inputs[prop])));
        return this._resolveChanges(changes);
    }
    _collectChangesFromDiffer(differ) {
        const changes = {};
        differ.forEachAddedItem((record) => (changes[record.key] = createNewChange(record.currentValue)));
        differ.forEachChangedItem((record) => (changes[record.key] = createChange(record.currentValue, record.previousValue)));
        return this._resolveChanges(changes);
    }
    _resolveCompFactory() {
        try {
            try {
                return this.cfr.resolveComponentFactory(this.compRef.componentType);
            }
            catch (e) {
                // Fallback if componentType does not exist (happens on NgComponentOutlet)
                return this.cfr.resolveComponentFactory(this.compRef.instance.constructor);
            }
        }
        catch (e) {
            // Factory not available - bailout
            return null;
        }
    }
    _updateCompFactory() {
        this.compFactory = this._resolveCompFactory();
    }
    _resolveInputs(inputs) {
        if (!this.compFactory) {
            return inputs;
        }
        return this._remapIO(inputs, this.compFactory.inputs);
    }
    _resolveOutputs(outputs) {
        outputs = this._processOutputs(outputs);
        if (!this.compFactory) {
            return outputs;
        }
        return this._remapIO(outputs, this.compFactory.outputs);
    }
    _processOutputs(outputs) {
        const processedOutputs = {};
        Object.keys(outputs).forEach((key) => {
            const outputExpr = outputs[key];
            if (typeof outputExpr === 'function') {
                processedOutputs[key] = outputExpr;
            }
            else {
                processedOutputs[key] =
                    outputExpr && this._processOutputArgs(outputExpr);
            }
        });
        return processedOutputs;
    }
    _processOutputArgs(output) {
        const { handler } = output;
        const args = 'args' in output ? output.args || [] : [this.eventArgument];
        return (event) => handler(...args.map((arg) => (arg === this.eventArgument ? event : arg)));
    }
    _resolveChanges(changes) {
        if (!this.compFactory) {
            return changes;
        }
        return this._remapIO(changes, this.compFactory.inputs);
    }
    _remapIO(io, mapping) {
        const newIO = {};
        Object.keys(io).forEach((key) => {
            const newKey = this._findPropByTplInMapping(key, mapping) || key;
            newIO[newKey] = io[key];
        });
        return newIO;
    }
    _findPropByTplInMapping(tplName, mapping) {
        for (const map of mapping) {
            if (map.templateName === tplName) {
                return map.propName;
            }
        }
        return null;
    }
    failInit() {
        throw Error('IoService: ComponentInjector was not set! Please call init() method!');
    }
}
/** @nocollapse */ /** @nocollapse */ IoService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: IoService, deps: [{ token: i0.KeyValueDiffers }, { token: i0.ComponentFactoryResolver }, { token: EventArgumentToken }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ /** @nocollapse */ IoService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: IoService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: IoService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i0.KeyValueDiffers }, { type: i0.ComponentFactoryResolver }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [EventArgumentToken]
                }] }, { type: i0.ChangeDetectorRef }]; } });

class IoFactoryService {
    constructor(differs, cfr, eventArgument, cdr) {
        this.differs = differs;
        this.cfr = cfr;
        this.eventArgument = eventArgument;
        this.cdr = cdr;
    }
    create() {
        return new IoService(this.differs, this.cfr, this.eventArgument, this.cdr);
    }
}
/** @nocollapse */ /** @nocollapse */ IoFactoryService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: IoFactoryService, deps: [{ token: i0.KeyValueDiffers }, { token: i0.ComponentFactoryResolver }, { token: EventArgumentToken }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ /** @nocollapse */ IoFactoryService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: IoFactoryService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: IoFactoryService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i0.KeyValueDiffers }, { type: i0.ComponentFactoryResolver }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [EventArgumentToken]
                }] }, { type: i0.ChangeDetectorRef }]; } });

/* eslint-disable @angular-eslint/no-conflicting-lifecycle */
class DynamicIoDirective {
    constructor(ioService, componentInjector) {
        this.ioService = ioService;
        this.componentInjector = componentInjector;
        this.ioService.init(this.componentInjector);
    }
    get inputs() {
        return this.ndcDynamicInputs || this.ngComponentOutletNdcDynamicInputs;
    }
    get outputs() {
        return this.ndcDynamicOutputs || this.ngComponentOutletNdcDynamicOutputs;
    }
    ngOnChanges(changes) {
        this.ioService.update(this.inputs, this.outputs, this.inputsChanged(changes), this.outputsChanged(changes));
    }
    ngDoCheck() {
        this.ioService.maybeUpdate();
    }
    inputsChanged(changes) {
        return ('ngComponentOutletNdcDynamicInputs' in changes ||
            'ndcDynamicInputs' in changes);
    }
    outputsChanged(changes) {
        return ('ngComponentOutletNdcDynamicOutputs' in changes ||
            'ndcDynamicOutputs' in changes);
    }
}
/** @nocollapse */ /** @nocollapse */ DynamicIoDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoDirective, deps: [{ token: IoService }, { token: DynamicComponentInjectorToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ /** @nocollapse */ DynamicIoDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.2", type: DynamicIoDirective, selector: "[ndcDynamicInputs],[ndcDynamicOutputs],[ngComponentOutletNdcDynamicInputs],[ngComponentOutletNdcDynamicOutputs]", inputs: { ndcDynamicInputs: "ndcDynamicInputs", ngComponentOutletNdcDynamicInputs: "ngComponentOutletNdcDynamicInputs", ndcDynamicOutputs: "ndcDynamicOutputs", ngComponentOutletNdcDynamicOutputs: "ngComponentOutletNdcDynamicOutputs" }, providers: [IoService], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ndcDynamicInputs],[ndcDynamicOutputs],[ngComponentOutletNdcDynamicInputs],[ngComponentOutletNdcDynamicOutputs]',
                    providers: [IoService],
                }]
        }], ctorParameters: function () { return [{ type: IoService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { ndcDynamicInputs: [{
                type: Input
            }], ngComponentOutletNdcDynamicInputs: [{
                type: Input
            }], ndcDynamicOutputs: [{
                type: Input
            }], ngComponentOutletNdcDynamicOutputs: [{
                type: Input
            }] } });

class DynamicIoModule {
}
/** @nocollapse */ /** @nocollapse */ DynamicIoModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ /** @nocollapse */ DynamicIoModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoModule, declarations: [DynamicIoDirective], imports: [CommonModule], exports: [DynamicIoDirective, ComponentOutletInjectorModule] });
/** @nocollapse */ /** @nocollapse */ DynamicIoModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoModule, imports: [[CommonModule], ComponentOutletInjectorModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicIoModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [CommonModule],
                    exports: [DynamicIoDirective, ComponentOutletInjectorModule],
                    declarations: [DynamicIoDirective],
                }]
        }] });

class DynamicComponent {
    constructor(vcr) {
        this.vcr = vcr;
        this.ndcDynamicCreated = new EventEmitter();
        this.componentRef = null;
    }
    ngOnChanges(changes) {
        if (DynamicComponent.UpdateOnInputs.some((input) => changes.hasOwnProperty(input))) {
            this.createDynamicComponent();
        }
    }
    createDynamicComponent() {
        this.vcr.clear();
        this.componentRef = null;
        if (this.ndcDynamicComponent) {
            this.componentRef = this.vcr.createComponent(this.ndcDynamicComponent, {
                index: 0,
                injector: this._resolveInjector(),
                projectableNodes: this.ndcDynamicContent,
            });
            this.ndcDynamicCreated.emit(this.componentRef);
        }
    }
    _resolveInjector() {
        let injector = this.ndcDynamicInjector || this.vcr.injector;
        if (this.ndcDynamicProviders) {
            injector = Injector.create({
                providers: this.ndcDynamicProviders,
                parent: injector,
            });
        }
        return injector;
    }
}
DynamicComponent.UpdateOnInputs = [
    'ndcDynamicComponent',
    'ndcDynamicInjector',
    'ndcDynamicProviders',
    'ndcDynamicContent',
];
/** @nocollapse */ /** @nocollapse */ DynamicComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicComponent, deps: [{ token: i0.ViewContainerRef }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ /** @nocollapse */ DynamicComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "13.0.2", type: DynamicComponent, selector: "ndc-dynamic", inputs: { ndcDynamicComponent: "ndcDynamicComponent", ndcDynamicInjector: "ndcDynamicInjector", ndcDynamicProviders: "ndcDynamicProviders", ndcDynamicContent: "ndcDynamicContent" }, outputs: { ndcDynamicCreated: "ndcDynamicCreated" }, providers: [
        { provide: DynamicComponentInjectorToken, useExisting: DynamicComponent },
    ], usesOnChanges: true, ngImport: i0, template: '', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'ndc-dynamic',
                    template: '',
                    providers: [
                        { provide: DynamicComponentInjectorToken, useExisting: DynamicComponent },
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.ViewContainerRef }]; }, propDecorators: { ndcDynamicComponent: [{
                type: Input
            }], ndcDynamicInjector: [{
                type: Input
            }], ndcDynamicProviders: [{
                type: Input
            }], ndcDynamicContent: [{
                type: Input
            }], ndcDynamicCreated: [{
                type: Output
            }] } });

class DynamicModule {
}
/** @nocollapse */ /** @nocollapse */ DynamicModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ /** @nocollapse */ DynamicModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicModule, declarations: [DynamicComponent], imports: [CommonModule, DynamicIoModule], exports: [DynamicComponent, DynamicIoModule] });
/** @nocollapse */ /** @nocollapse */ DynamicModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicModule, imports: [[CommonModule, DynamicIoModule], DynamicIoModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [CommonModule, DynamicIoModule],
                    exports: [DynamicComponent, DynamicIoModule],
                    declarations: [DynamicComponent],
                }]
        }] });

class DynamicAttributesDirective {
    constructor(renderer, differs, injector, componentInjector) {
        this.renderer = renderer;
        this.differs = differs;
        this.injector = injector;
        this.componentInjector = componentInjector;
        this.attrsDiffer = this.differs.find({}).create();
    }
    get _attributes() {
        return (this.ndcDynamicAttributes || this.ngComponentOutletNdcDynamicAttributes);
    }
    get _nativeElement() {
        return this.componentInjector.componentRef?.location.nativeElement;
    }
    get _compType() {
        return this.componentInjector.componentRef?.componentType;
    }
    get _isCompChanged() {
        if (this.lastCompType !== this._compType) {
            this.lastCompType = this._compType;
            return true;
        }
        return false;
    }
    ngDoCheck() {
        const isCompChanged = this._isCompChanged;
        const changes = this.attrsDiffer.diff(this._attributes);
        if (changes) {
            this.lastAttrActions = this._changesToAttrActions(changes);
        }
        if (changes || (isCompChanged && this.lastAttrActions)) {
            this._updateAttributes(this.lastAttrActions);
        }
    }
    setAttribute(name, value, namespace) {
        if (this._nativeElement) {
            this.renderer.setAttribute(this._nativeElement, name, value, namespace);
        }
    }
    removeAttribute(name, namespace) {
        if (this._nativeElement) {
            this.renderer.removeAttribute(this._nativeElement, name, namespace);
        }
    }
    _updateAttributes(actions) {
        // ? Early exit if no dynamic component
        if (!this._compType) {
            return;
        }
        Object.keys(actions.set).forEach((key) => this.setAttribute(key, actions.set[key]));
        actions.remove.forEach((key) => this.removeAttribute(key));
    }
    _changesToAttrActions(changes) {
        const attrActions = {
            set: {},
            remove: [],
        };
        changes.forEachAddedItem((r) => (attrActions.set[r.key] = r.currentValue));
        changes.forEachChangedItem((r) => (attrActions.set[r.key] = r.currentValue));
        changes.forEachRemovedItem((r) => attrActions.remove.push(r.key));
        return attrActions;
    }
}
/** @nocollapse */ /** @nocollapse */ DynamicAttributesDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesDirective, deps: [{ token: i0.Renderer2 }, { token: i0.KeyValueDiffers }, { token: i0.Injector }, { token: DynamicComponentInjectorToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ /** @nocollapse */ DynamicAttributesDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.2", type: DynamicAttributesDirective, selector: "[ndcDynamicAttributes],[ngComponentOutletNdcDynamicAttributes]", inputs: { ndcDynamicAttributes: "ndcDynamicAttributes", ngComponentOutletNdcDynamicAttributes: "ngComponentOutletNdcDynamicAttributes" }, exportAs: ["ndcDynamicAttributes"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ndcDynamicAttributes],[ngComponentOutletNdcDynamicAttributes]',
                    exportAs: 'ndcDynamicAttributes',
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.KeyValueDiffers }, { type: i0.Injector }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { ndcDynamicAttributes: [{
                type: Input
            }], ngComponentOutletNdcDynamicAttributes: [{
                type: Input
            }] } });

class DynamicAttributesModule {
}
/** @nocollapse */ /** @nocollapse */ DynamicAttributesModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ /** @nocollapse */ DynamicAttributesModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesModule, declarations: [DynamicAttributesDirective], imports: [CommonModule], exports: [DynamicAttributesDirective, ComponentOutletInjectorModule] });
/** @nocollapse */ /** @nocollapse */ DynamicAttributesModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesModule, imports: [[CommonModule], ComponentOutletInjectorModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [CommonModule],
                    exports: [DynamicAttributesDirective, ComponentOutletInjectorModule],
                    declarations: [DynamicAttributesDirective],
                }]
        }] });

function browserWindowFactory() {
    return window;
}

const WindowRefToken = new InjectionToken('WindowRef', {
    providedIn: 'root',
    factory: browserWindowFactory,
});
class WindowRefService {
    constructor(injector) {
        this.injector = injector;
        this.nativeWindow = this.injector.get(WindowRefToken, null);
    }
}
/** @nocollapse */ /** @nocollapse */ WindowRefService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: WindowRefService, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ /** @nocollapse */ WindowRefService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: WindowRefService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: WindowRefService, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });

function dynamicDirectiveDef(type, inputs, outputs) {
    return { type, inputs, outputs };
}
class DynamicDirectivesDirective {
    constructor(iterableDiffers, ioFactoryService, windowRef, componentInjector) {
        this.iterableDiffers = iterableDiffers;
        this.ioFactoryService = ioFactoryService;
        this.windowRef = windowRef;
        this.componentInjector = componentInjector;
        this.ndcDynamicDirectivesCreated = new EventEmitter();
        this.dirRef = new Map();
        this.dirIo = new Map();
        this.dirsDiffer = this.iterableDiffers
            .find([])
            .create((_, def) => def.type);
    }
    get directives() {
        return (this.ndcDynamicDirectives || this.ngComponentOutletNdcDynamicDirectives);
    }
    get componentRef() {
        return this.componentInjector.componentRef;
    }
    get compInstance() {
        return this.componentRef && this.componentRef.instance;
    }
    get isCompChanged() {
        if (this.lastCompInstance !== this.compInstance) {
            this.lastCompInstance = this.compInstance;
            return true;
        }
        return false;
    }
    get hostInjector() {
        return this.componentRef.injector;
    }
    get hostVcr() {
        // NOTE: Accessing private APIs of Angular
        // eslint-disable-next-line @typescript-eslint/dot-notation
        return this.componentRef['_viewRef']['_viewContainerRef'];
    }
    get reflect() {
        return this.windowRef.nativeWindow.Reflect;
    }
    ngDoCheck() {
        if (this.maybeDestroyDirectives()) {
            return;
        }
        const dirsChanges = this.dirsDiffer.diff(this.directives);
        if (!dirsChanges) {
            return this.updateDirectives();
        }
        this.processDirChanges(dirsChanges);
    }
    ngOnDestroy() {
        this.destroyAllDirectives();
    }
    maybeDestroyDirectives() {
        if (this.isCompChanged || !this.componentRef) {
            this.dirsDiffer.diff([]);
            this.destroyAllDirectives();
        }
        return !this.componentRef;
    }
    processDirChanges(changes) {
        changes.forEachRemovedItem(({ item }) => this.destroyDirective(item));
        const createdDirs = [];
        changes.forEachAddedItem(({ item }) => createdDirs.push(this.initDirective(item)));
        if (createdDirs.length) {
            this.ndcDynamicDirectivesCreated.emit(createdDirs.filter(Boolean));
        }
    }
    updateDirectives() {
        this.directives.forEach((dir) => this.updateDirective(dir));
    }
    updateDirective(dirDef) {
        const io = this.dirIo.get(dirDef.type);
        io.update(dirDef.inputs, dirDef.outputs, false, false);
        io.maybeUpdate();
    }
    initDirective(dirDef) {
        if (this.dirRef.has(dirDef.type)) {
            return;
        }
        const instance = this.createDirective(dirDef.type);
        const dir = {
            instance,
            type: dirDef.type,
            injector: this.hostInjector,
            hostComponent: this.componentRef.instance,
            hostView: this.componentRef.hostView,
            location: this.componentRef.location,
            changeDetectorRef: this.componentRef.changeDetectorRef,
            onDestroy: this.componentRef.onDestroy,
        };
        this.initDirIO(dir, dirDef.inputs, dirDef.outputs);
        this.callInitHooks(instance);
        this.dirRef.set(dir.type, dir);
        return dir;
    }
    destroyAllDirectives() {
        this.dirRef.forEach((dir) => this.destroyDirRef(dir));
        this.dirRef.clear();
        this.dirIo.clear();
    }
    destroyDirective(dirDef) {
        this.destroyDirRef(this.dirRef.get(dirDef.type));
        this.dirRef.delete(dirDef.type);
        this.dirIo.delete(dirDef.type);
    }
    initDirIO(dir, inputs, outputs) {
        const io = this.ioFactoryService.create();
        io.init({ componentRef: this.dirToCompDef(dir) }, { trackOutputChanges: true });
        io.update(inputs, outputs, !!inputs, !!outputs);
        this.dirIo.set(dir.type, io);
    }
    dirToCompDef(dir) {
        return {
            changeDetectorRef: this.componentRef.changeDetectorRef,
            hostView: this.componentRef.hostView,
            location: this.componentRef.location,
            destroy: this.componentRef.destroy,
            onDestroy: this.componentRef.onDestroy,
            injector: this.componentRef.injector,
            instance: dir.instance,
            componentType: dir.type,
        };
    }
    destroyDirRef(dir) {
        const io = this.dirIo.get(dir.type);
        io.ngOnDestroy();
        if ('ngOnDestroy' in dir.instance) {
            dir.instance.ngOnDestroy();
        }
    }
    createDirective(dirType) {
        const directiveInjector = Injector.create({
            providers: [
                {
                    provide: dirType,
                    useClass: dirType,
                    deps: this.resolveDirParamTypes(dirType),
                },
                { provide: ElementRef, useValue: this.componentRef.location },
            ],
            parent: this.hostInjector,
            name: `DynamicDirectiveInjector:${dirType.name}@${this.componentRef.componentType.name}`,
        });
        return directiveInjector.get(dirType);
    }
    resolveDirParamTypes(dirType) {
        return (
        // First try Angular Compiler's metadata
        extractNgParamTypes(dirType) ??
            // Then fallback to Typescript Reflect API
            getCtorParamTypes(dirType, this.reflect) ??
            // Bailout
            []);
    }
    callInitHooks(obj) {
        this.callHook(obj, 'ngOnInit');
        this.callHook(obj, 'ngDoCheck');
        this.callHook(obj, 'ngAfterContentInit');
        this.callHook(obj, 'ngAfterContentChecked');
        this.callHook(obj, 'ngAfterViewInit');
        this.callHook(obj, 'ngAfterViewChecked');
    }
    callHook(obj, hook, args = []) {
        if (obj[hook]) {
            obj[hook](...args);
        }
    }
}
/** @nocollapse */ /** @nocollapse */ DynamicDirectivesDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesDirective, deps: [{ token: i0.IterableDiffers }, { token: IoFactoryService }, { token: WindowRefService }, { token: DynamicComponentInjectorToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ /** @nocollapse */ DynamicDirectivesDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.2", type: DynamicDirectivesDirective, selector: "[ndcDynamicDirectives],[ngComponentOutletNdcDynamicDirectives]", inputs: { ndcDynamicDirectives: "ndcDynamicDirectives", ngComponentOutletNdcDynamicDirectives: "ngComponentOutletNdcDynamicDirectives" }, outputs: { ndcDynamicDirectivesCreated: "ndcDynamicDirectivesCreated" }, providers: [IoFactoryService], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ndcDynamicDirectives],[ngComponentOutletNdcDynamicDirectives]',
                    providers: [IoFactoryService],
                }]
        }], ctorParameters: function () { return [{ type: i0.IterableDiffers }, { type: IoFactoryService }, { type: WindowRefService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { ndcDynamicDirectives: [{
                type: Input
            }], ngComponentOutletNdcDynamicDirectives: [{
                type: Input
            }], ndcDynamicDirectivesCreated: [{
                type: Output
            }] } });

class DynamicDirectivesModule {
}
/** @nocollapse */ /** @nocollapse */ DynamicDirectivesModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ /** @nocollapse */ DynamicDirectivesModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesModule, declarations: [DynamicDirectivesDirective], imports: [CommonModule], exports: [DynamicDirectivesDirective, ComponentOutletInjectorModule] });
/** @nocollapse */ /** @nocollapse */ DynamicDirectivesModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesModule, imports: [[CommonModule], ComponentOutletInjectorModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [CommonModule],
                    exports: [DynamicDirectivesDirective, ComponentOutletInjectorModule],
                    declarations: [DynamicDirectivesDirective],
                }]
        }] });

/*
 * Public API Surface of ng-dynamic-component
 */

/**
 * Generated bundle index. Do not edit.
 */

export { ComponentOutletInjectorDirective, ComponentOutletInjectorModule, DynamicAttributesDirective, DynamicAttributesModule, DynamicComponent, DynamicComponentInjectorToken, DynamicDirectivesDirective, DynamicDirectivesModule, DynamicIoDirective, DynamicIoModule, DynamicModule, EventArgumentToken, defaultEventArgumentFactory, dynamicDirectiveDef };
//# sourceMappingURL=ng-dynamic-component.mjs.map
