import { InputManager } from "./input.manager";
import { CurrencyMaskConfig } from "./currency-mask.config";
export declare class InputService {
    private htmlInputElement;
    private options;
    private SINGLE_DIGIT_REGEX;
    private ONLY_NUMBERS_REGEX;
    PER_AR_NUMBER: Map<string, string>;
    initialize(): void;
    inputManager: InputManager;
    constructor(htmlInputElement: any, options: CurrencyMaskConfig);
    addNumber(keyCode: number): void;
    applyMask(isNumber: boolean, rawValue: string, disablePadAndTrim?: boolean): string;
    padOrTrimPrecision(rawValue: string): string;
    clearMask(rawValue: string): number;
    changeToNegative(): void;
    changeToPositive(): void;
    removeNumber(keyCode: number): void;
    updateFieldValue(selectionStart?: number, disablePadAndTrim?: boolean): void;
    updateOptions(options: any): void;
    prefixLength(): any;
    suffixLength(): any;
    isNullable(): boolean;
    get canInputMoreNumbers(): boolean;
    get inputSelection(): any;
    get rawValue(): string;
    set rawValue(value: string);
    get storedRawValue(): string;
    get value(): number;
    set value(value: number);
    private isNullOrUndefined;
}
