import { EventEmitter, InjectionToken } from '@angular/core';
export const NGX_MASK_CONFIG = new InjectionToken('ngx-mask config');
export const NEW_CONFIG = new InjectionToken('new ngx-mask config');
export const INITIAL_CONFIG = new InjectionToken('initial ngx-mask config');
export const initialConfig = {
    suffix: '',
    prefix: '',
    thousandSeparator: ' ',
    decimalMarker: ['.', ','],
    clearIfNotMatch: false,
    showTemplate: false,
    showMaskTyped: false,
    placeHolderCharacter: '_',
    dropSpecialCharacters: true,
    hiddenInput: undefined,
    shownMaskExpression: '',
    separatorLimit: '',
    allowNegativeNumbers: false,
    validation: true,
    // eslint-disable-next-line @typescript-eslint/quotes
    specialCharacters: ['-', '/', '(', ')', '.', ':', ' ', '+', ',', '@', '[', ']', '"', "'"],
    leadZeroDateTime: false,
    apm: false,
    leadZero: false,
    keepCharacterPositions: false,
    triggerOnMaskChange: false,
    inputTransformFn: (value) => value,
    outputTransformFn: (value) => value,
    maskFilled: new EventEmitter(),
    patterns: {
        '0': {
            pattern: new RegExp('\\d'),
        },
        '9': {
            pattern: new RegExp('\\d'),
            optional: true,
        },
        X: {
            pattern: new RegExp('\\d'),
            symbol: '*',
        },
        A: {
            pattern: new RegExp('[a-zA-Z0-9]'),
        },
        S: {
            pattern: new RegExp('[a-zA-Z]'),
        },
        U: {
            pattern: new RegExp('[A-Z]'),
        },
        L: {
            pattern: new RegExp('[a-z]'),
        },
        d: {
            pattern: new RegExp('\\d'),
        },
        m: {
            pattern: new RegExp('\\d'),
        },
        M: {
            pattern: new RegExp('\\d'),
        },
        H: {
            pattern: new RegExp('\\d'),
        },
        h: {
            pattern: new RegExp('\\d'),
        },
        s: {
            pattern: new RegExp('\\d'),
        },
    },
};
export const timeMasks = [
    "Hh:m0:s0" /* HOURS_MINUTES_SECONDS */,
    "Hh:m0" /* HOURS_MINUTES */,
    "m0:s0" /* MINUTES_SECONDS */,
];
export const withoutValidation = [
    "percent" /* PERCENT */,
    "Hh" /* HOURS_HOUR */,
    "s0" /* SECONDS */,
    "m0" /* MINUTES */,
    "separator" /* SEPARATOR */,
    "d0/M0/0000" /* DAYS_MONTHS_YEARS */,
    "d0/M0" /* DAYS_MONTHS */,
    "d0" /* DAYS */,
    "M0" /* MONTHS */,
];
//# sourceMappingURL=data:application/json;base64,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