import { DOCUMENT } from '@angular/common';
import { Directive, EventEmitter, HostListener, Input, Output, forwardRef, Inject, } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR, } from '@angular/forms';
import { NGX_MASK_CONFIG, timeMasks, withoutValidation } from './ngx-mask.config';
import { NgxMaskService } from './ngx-mask.service';
import * as i0 from "@angular/core";
import * as i1 from "./ngx-mask.service";
// tslint:disable deprecation
// tslint:disable no-input-rename
export class NgxMaskDirective {
    constructor(
    // tslint:disable-next-line
    document, _config, _maskService) {
        this.document = document;
        this._config = _config;
        this._maskService = _maskService;
        // eslint-disable-next-line @angular-eslint/no-input-rename
        this.maskExpression = '';
        this.specialCharacters = [];
        this.patterns = {};
        this.prefix = '';
        this.suffix = '';
        this.thousandSeparator = ' ';
        this.decimalMarker = '.';
        this.dropSpecialCharacters = null;
        this.hiddenInput = null;
        this.showMaskTyped = null;
        this.placeHolderCharacter = null;
        this.shownMaskExpression = null;
        this.showTemplate = null;
        this.clearIfNotMatch = null;
        this.validation = null;
        this.separatorLimit = null;
        this.allowNegativeNumbers = null;
        this.leadZeroDateTime = null;
        this.leadZero = null;
        this.triggerOnMaskChange = null;
        this.apm = null;
        this.inputTransformFn = null;
        this.outputTransformFn = null;
        this.keepCharacterPositions = null;
        this.maskFilled = new EventEmitter();
        this._maskValue = '';
        this._isFocused = false;
        this._position = null;
        this._maskExpressionArray = [];
        this._justPasted = false;
        /**For IME composition event */
        this._isComposing = false;
        // eslint-disable-next-line @typescript-eslint/no-empty-function, @typescript-eslint/no-explicit-any
        this.onChange = (_) => { };
        // eslint-disable-next-line @typescript-eslint/no-empty-function
        this.onTouch = () => { };
    }
    ngOnChanges(changes) {
        const { maskExpression, specialCharacters, patterns, prefix, suffix, thousandSeparator, decimalMarker, dropSpecialCharacters, hiddenInput, showMaskTyped, placeHolderCharacter, shownMaskExpression, showTemplate, clearIfNotMatch, validation, separatorLimit, allowNegativeNumbers, leadZeroDateTime, leadZero, triggerOnMaskChange, apm, inputTransformFn, outputTransformFn, keepCharacterPositions, } = changes;
        if (maskExpression) {
            if (maskExpression.currentValue !== maskExpression.previousValue &&
                !maskExpression.firstChange) {
                this._maskService.maskChanged = true;
            }
            if (maskExpression.currentValue &&
                maskExpression.currentValue.split("||" /* OR */).length > 1) {
                this._maskExpressionArray = maskExpression.currentValue
                    .split("||" /* OR */)
                    .sort((a, b) => {
                    return a.length - b.length;
                });
                this._setMask();
            }
            else {
                this._maskExpressionArray = [];
                this._maskValue = maskExpression.currentValue || "" /* EMPTY_STRING */;
                this._maskService.maskExpression = this._maskValue;
            }
        }
        if (specialCharacters) {
            if (!specialCharacters.currentValue || !Array.isArray(specialCharacters.currentValue)) {
                return;
            }
            else {
                this._maskService.specialCharacters = specialCharacters.currentValue || [];
            }
        }
        if (allowNegativeNumbers) {
            this._maskService.allowNegativeNumbers = allowNegativeNumbers.currentValue;
            if (this._maskService.allowNegativeNumbers) {
                this._maskService.specialCharacters = this._maskService.specialCharacters.filter((c) => c !== "-" /* MINUS */);
            }
        }
        // Only overwrite the mask available patterns if a pattern has actually been passed in
        if (patterns && patterns.currentValue) {
            this._maskService.patterns = patterns.currentValue;
        }
        if (apm && apm.currentValue) {
            this._maskService.apm = apm.currentValue;
        }
        if (prefix) {
            this._maskService.prefix = prefix.currentValue;
        }
        if (suffix) {
            this._maskService.suffix = suffix.currentValue;
        }
        if (thousandSeparator) {
            this._maskService.thousandSeparator = thousandSeparator.currentValue;
        }
        if (decimalMarker) {
            this._maskService.decimalMarker = decimalMarker.currentValue;
        }
        if (dropSpecialCharacters) {
            this._maskService.dropSpecialCharacters = dropSpecialCharacters.currentValue;
        }
        if (hiddenInput) {
            this._maskService.hiddenInput = hiddenInput.currentValue;
        }
        if (showMaskTyped) {
            this._maskService.showMaskTyped = showMaskTyped.currentValue;
            if (showMaskTyped.previousValue === false &&
                showMaskTyped.currentValue === true &&
                this._isFocused) {
                requestAnimationFrame(() => {
                    this._maskService._elementRef?.nativeElement.click();
                });
            }
        }
        if (placeHolderCharacter) {
            this._maskService.placeHolderCharacter = placeHolderCharacter.currentValue;
        }
        if (shownMaskExpression) {
            this._maskService.shownMaskExpression = shownMaskExpression.currentValue;
        }
        if (showTemplate) {
            this._maskService.showTemplate = showTemplate.currentValue;
        }
        if (clearIfNotMatch) {
            this._maskService.clearIfNotMatch = clearIfNotMatch.currentValue;
        }
        if (validation) {
            this._maskService.validation = validation.currentValue;
        }
        if (separatorLimit) {
            this._maskService.separatorLimit = separatorLimit.currentValue;
        }
        if (leadZeroDateTime) {
            this._maskService.leadZeroDateTime = leadZeroDateTime.currentValue;
        }
        if (leadZero) {
            this._maskService.leadZero = leadZero.currentValue;
        }
        if (triggerOnMaskChange) {
            this._maskService.triggerOnMaskChange = triggerOnMaskChange.currentValue;
        }
        if (inputTransformFn) {
            this._maskService.inputTransformFn = inputTransformFn.currentValue;
        }
        if (outputTransformFn) {
            this._maskService.outputTransformFn = outputTransformFn.currentValue;
        }
        if (keepCharacterPositions) {
            this._maskService.keepCharacterPositions = keepCharacterPositions.currentValue;
        }
        this._applyMask();
    }
    // eslint-disable-next-line complexity
    validate({ value }) {
        if (!this._maskService.validation || !this._maskValue) {
            return null;
        }
        if (this._maskService.ipError) {
            return this._createValidationError(value);
        }
        if (this._maskService.cpfCnpjError) {
            return this._createValidationError(value);
        }
        if (this._maskValue.startsWith("separator" /* SEPARATOR */)) {
            return null;
        }
        if (withoutValidation.includes(this._maskValue)) {
            return null;
        }
        if (this._maskService.clearIfNotMatch) {
            return null;
        }
        if (timeMasks.includes(this._maskValue)) {
            return this._validateTime(value);
        }
        if (value && value.toString().length >= 1) {
            let counterOfOpt = 0;
            if (this._maskValue.startsWith("percent" /* PERCENT */)) {
                return null;
            }
            for (const key in this._maskService.patterns) {
                if (this._maskService.patterns[key]?.optional) {
                    if (this._maskValue.indexOf(key) !== this._maskValue.lastIndexOf(key)) {
                        const opt = this._maskValue
                            .split("" /* EMPTY_STRING */)
                            .filter((i) => i === key)
                            .join("" /* EMPTY_STRING */);
                        counterOfOpt += opt.length;
                    }
                    else if (this._maskValue.indexOf(key) !== -1) {
                        counterOfOpt++;
                    }
                    if (this._maskValue.indexOf(key) !== -1 &&
                        value.toString().length >= this._maskValue.indexOf(key)) {
                        return null;
                    }
                    if (counterOfOpt === this._maskValue.length) {
                        return null;
                    }
                }
            }
            if (this._maskValue.indexOf("{" /* CURLY_BRACKETS_LEFT */) === 1 &&
                value.toString().length ===
                    this._maskValue.length +
                        Number((this._maskValue.split("{" /* CURLY_BRACKETS_LEFT */)[1] ??
                            "" /* EMPTY_STRING */).split("}" /* CURLY_BRACKETS_RIGHT */)[0]) -
                        4) {
                return null;
            }
            else if ((this._maskValue.indexOf("*" /* SYMBOL_STAR */) > 1 &&
                value.toString().length <
                    this._maskValue.indexOf("*" /* SYMBOL_STAR */)) ||
                (this._maskValue.indexOf("?" /* SYMBOL_QUESTION */) > 1 &&
                    value.toString().length <
                        this._maskValue.indexOf("?" /* SYMBOL_QUESTION */)) ||
                this._maskValue.indexOf("{" /* CURLY_BRACKETS_LEFT */) === 1) {
                return this._createValidationError(value);
            }
            if (this._maskValue.indexOf("*" /* SYMBOL_STAR */) === -1 ||
                this._maskValue.indexOf("?" /* SYMBOL_QUESTION */) === -1) {
                // eslint-disable-next-line no-param-reassign
                value = typeof value === 'number' ? String(value) : value;
                const array = this._maskValue.split('*');
                const length = this._maskService.dropSpecialCharacters
                    ? this._maskValue.length -
                        this._maskService.checkDropSpecialCharAmount(this._maskValue) -
                        counterOfOpt
                    : this.prefix
                        ? this._maskValue.length + this.prefix.length - counterOfOpt
                        : this._maskValue.length - counterOfOpt;
                if (array.length === 1) {
                    if (value.toString().length < length) {
                        return this._createValidationError(value);
                    }
                }
                if (array.length > 1) {
                    const lastIndexArray = array[array.length - 1];
                    if (lastIndexArray &&
                        this._maskService.specialCharacters.includes(lastIndexArray[0]) &&
                        String(value).includes(lastIndexArray[0] ?? '') &&
                        !this.dropSpecialCharacters) {
                        const special = value.split(lastIndexArray[0]);
                        return special[special.length - 1].length === lastIndexArray.length - 1
                            ? null
                            : this._createValidationError(value);
                    }
                    else if (((lastIndexArray &&
                        !this._maskService.specialCharacters.includes(lastIndexArray[0])) ||
                        !lastIndexArray ||
                        this._maskService.dropSpecialCharacters) &&
                        value.length >= length - 1) {
                        return null;
                    }
                    else {
                        return this._createValidationError(value);
                    }
                }
            }
            if (this._maskValue.indexOf("*" /* SYMBOL_STAR */) === 1 ||
                this._maskValue.indexOf("?" /* SYMBOL_QUESTION */) === 1) {
                return null;
            }
        }
        if (value) {
            this.maskFilled.emit();
            return null;
        }
        return null;
    }
    onPaste() {
        this._justPasted = true;
    }
    onFocus() {
        this._isFocused = true;
    }
    onModelChange(value) {
        // on form reset we need to update the actualValue
        if ((value === "" /* EMPTY_STRING */ || value === null || value === undefined) &&
            this._maskService.actualValue) {
            this._maskService.actualValue = this._maskService.getActualValue("" /* EMPTY_STRING */);
        }
    }
    onInput(e) {
        // If IME is composing text, we wait for the composed text.
        if (this._isComposing)
            return;
        const el = e.target;
        const transformedValue = this._maskService.inputTransformFn(el.value);
        if (el.type !== 'number') {
            if (typeof transformedValue === 'string' || typeof transformedValue === 'number') {
                el.value = transformedValue.toString();
                this._inputValue = el.value;
                this._setMask();
                if (!this._maskValue) {
                    this.onChange(el.value);
                    return;
                }
                let position = el.selectionStart === 1
                    ? el.selectionStart + this._maskService.prefix.length
                    : el.selectionStart;
                if (this.showMaskTyped &&
                    this.keepCharacterPositions &&
                    this._maskService.placeHolderCharacter.length === 1) {
                    const inputSymbol = el.value.slice(position - 1, position);
                    const prefixLength = this.prefix.length;
                    const checkSymbols = this._maskService._checkSymbolMask(inputSymbol, this._maskService.maskExpression[position - 1 - prefixLength] ??
                        "" /* EMPTY_STRING */);
                    const checkSpecialCharacter = this._maskService._checkSymbolMask(inputSymbol, this._maskService.maskExpression[position + 1 - prefixLength] ??
                        "" /* EMPTY_STRING */);
                    const selectRangeBackspace = this._maskService.selStart === this._maskService.selEnd;
                    const selStart = Number(this._maskService.selStart) - prefixLength ?? '';
                    const selEnd = Number(this._maskService.selEnd) - prefixLength ?? '';
                    if (this._code === "Backspace" /* BACKSPACE */) {
                        if (!selectRangeBackspace) {
                            if (this._maskService.selStart === prefixLength) {
                                this._maskService.actualValue =
                                    this.prefix +
                                        this._maskService.maskIsShown.slice(0, selEnd) +
                                        this._inputValue.split(this.prefix).join('');
                            }
                            else if (this._maskService.selStart ===
                                this._maskService.maskIsShown.length + prefixLength) {
                                this._maskService.actualValue =
                                    this._inputValue +
                                        this._maskService.maskIsShown.slice(selStart, selEnd);
                            }
                            else {
                                this._maskService.actualValue =
                                    this.prefix +
                                        this._inputValue
                                            .split(this.prefix)
                                            .join('')
                                            .slice(0, selStart) +
                                        this._maskService.maskIsShown.slice(selStart, selEnd) +
                                        this._maskService.actualValue.slice(selEnd + prefixLength, this._maskService.maskIsShown.length + prefixLength) +
                                        this.suffix;
                            }
                        }
                        else if (!this._maskService.specialCharacters.includes(this._maskService.maskExpression.slice(position - this.prefix.length, position + 1 - this.prefix.length)) &&
                            selectRangeBackspace) {
                            if (selStart === 1 && this.prefix) {
                                this._maskService.actualValue =
                                    this.prefix +
                                        this._maskService.placeHolderCharacter +
                                        el.value
                                            .split(this.prefix)
                                            .join('')
                                            .split(this.suffix)
                                            .join('') +
                                        this.suffix;
                                position = position - 1;
                            }
                            else {
                                const part1 = el.value.substring(0, position);
                                const part2 = el.value.substring(position);
                                this._maskService.actualValue =
                                    part1 + this._maskService.placeHolderCharacter + part2;
                            }
                        }
                    }
                    if (this._code !== "Backspace" /* BACKSPACE */) {
                        if (!checkSymbols && !checkSpecialCharacter && selectRangeBackspace) {
                            position = Number(el.selectionStart) - 1;
                        }
                        else if (this._maskService.specialCharacters.includes(el.value.slice(position, position + 1)) &&
                            checkSpecialCharacter &&
                            !this._maskService.specialCharacters.includes(el.value.slice(position + 1, position + 2))) {
                            this._maskService.actualValue =
                                el.value.slice(0, position - 1) +
                                    el.value.slice(position, position + 1) +
                                    inputSymbol +
                                    el.value.slice(position + 2);
                            position = position + 1;
                        }
                        else if (checkSymbols) {
                            if (el.value.length === 1 && position === 1) {
                                this._maskService.actualValue =
                                    this.prefix +
                                        inputSymbol +
                                        this._maskService.maskIsShown.slice(1, this._maskService.maskIsShown.length) +
                                        this.suffix;
                            }
                            else {
                                this._maskService.actualValue =
                                    el.value.slice(0, position - 1) +
                                        inputSymbol +
                                        el.value
                                            .slice(position + 1)
                                            .split(this.suffix)
                                            .join('') +
                                        this.suffix;
                            }
                        }
                        else if (this.prefix &&
                            el.value.length === 1 &&
                            position - prefixLength === 1 &&
                            this._maskService._checkSymbolMask(el.value, this._maskService.maskExpression[position - 1 - prefixLength] ??
                                "" /* EMPTY_STRING */)) {
                            this._maskService.actualValue =
                                this.prefix +
                                    el.value +
                                    this._maskService.maskIsShown.slice(1, this._maskService.maskIsShown.length) +
                                    this.suffix;
                        }
                    }
                }
                let caretShift = 0;
                let backspaceShift = false;
                if (this._code === "Delete" /* DELETE */ && "separator" /* SEPARATOR */) {
                    this._maskService.deletedSpecialCharacter = true;
                }
                if (this._inputValue.length >= this._maskService.maskExpression.length - 1 &&
                    this._code !== "Backspace" /* BACKSPACE */ &&
                    this._maskService.maskExpression === "d0/M0/0000" /* DAYS_MONTHS_YEARS */ &&
                    position < 10) {
                    const inputSymbol = this._inputValue.slice(position - 1, position);
                    el.value =
                        this._inputValue.slice(0, position - 1) +
                            inputSymbol +
                            this._inputValue.slice(position + 1);
                }
                if (this._maskService.maskExpression === "d0/M0/0000" /* DAYS_MONTHS_YEARS */ &&
                    this.leadZeroDateTime) {
                    if ((position < 3 && Number(el.value) > 31 && Number(el.value) < 40) ||
                        (position === 5 && Number(el.value.slice(3, 5)) > 12)) {
                        position = position + 2;
                    }
                }
                if (this._maskService.maskExpression === "Hh:m0:s0" /* HOURS_MINUTES_SECONDS */ &&
                    this.apm) {
                    if (this._justPasted && el.value.slice(0, 2) === "00" /* DOUBLE_ZERO */) {
                        el.value = el.value.slice(1, 2) + el.value.slice(2, el.value.length);
                    }
                    el.value =
                        el.value === "00" /* DOUBLE_ZERO */
                            ? "0" /* NUMBER_ZERO */
                            : el.value;
                }
                this._maskService.applyValueChanges(position, this._justPasted, this._code === "Backspace" /* BACKSPACE */ || this._code === "Delete" /* DELETE */, (shift, _backspaceShift) => {
                    this._justPasted = false;
                    caretShift = shift;
                    backspaceShift = _backspaceShift;
                });
                // only set the selection if the element is active
                if (this._getActiveElement() !== el) {
                    return;
                }
                if (this._maskService.plusOnePosition) {
                    position = position + 1;
                    this._maskService.plusOnePosition = false;
                }
                // update position after applyValueChanges to prevent cursor on wrong position when it has an array of maskExpression
                if (this._maskExpressionArray.length) {
                    if (this._code === "Backspace" /* BACKSPACE */) {
                        position = this.specialCharacters.includes(this._inputValue.slice(position - 1, position))
                            ? position - 1
                            : position;
                    }
                    else {
                        position =
                            el.selectionStart === 1
                                ? el.selectionStart + this._maskService.prefix.length
                                : el.selectionStart;
                    }
                }
                this._position =
                    this._position === 1 && this._inputValue.length === 1 ? null : this._position;
                let positionToApply = this._position
                    ? this._inputValue.length + position + caretShift
                    : position +
                        (this._code === "Backspace" /* BACKSPACE */ && !backspaceShift ? 0 : caretShift);
                if (positionToApply > this._getActualInputLength()) {
                    positionToApply =
                        el.value === this._maskService.decimalMarker && el.value.length === 1
                            ? this._getActualInputLength() + 1
                            : this._getActualInputLength();
                }
                if (positionToApply < 0) {
                    positionToApply = 0;
                }
                el.setSelectionRange(positionToApply, positionToApply);
                this._position = null;
            }
            else {
                console.warn('Ngx-mask writeValue work with string | number, your current value:', typeof transformedValue);
            }
        }
        else {
            if (!this._maskValue) {
                this.onChange(el.value);
                return;
            }
            this._maskService.applyValueChanges(el.value.length, this._justPasted, this._code === "Backspace" /* BACKSPACE */ || this._code === "Delete" /* DELETE */);
        }
    }
    // IME starts
    onCompositionStart() {
        this._isComposing = true;
    }
    // IME completes
    onCompositionEnd(e) {
        this._isComposing = false;
        this._justPasted = true;
        this.onInput(e);
    }
    onBlur(e) {
        if (this._maskValue) {
            const el = e.target;
            if (this.leadZero && el.value.length > 0 && typeof this.decimalMarker === 'string') {
                const maskExpression = this._maskService.maskExpression;
                const precision = Number(this._maskService.maskExpression.slice(maskExpression.length - 1, maskExpression.length));
                if (precision > 1) {
                    el.value = this.suffix ? el.value.split(this.suffix).join('') : el.value;
                    const decimalPart = el.value.split(this.decimalMarker)[1];
                    el.value = el.value.includes(this.decimalMarker)
                        ? el.value +
                            "0" /* NUMBER_ZERO */.repeat(precision - decimalPart.length) +
                            this.suffix
                        : el.value +
                            this.decimalMarker +
                            "0" /* NUMBER_ZERO */.repeat(precision) +
                            this.suffix;
                    this._maskService.actualValue = el.value;
                }
            }
            this._maskService.clearIfNotMatchFn();
        }
        this._isFocused = false;
        this.onTouch();
    }
    onClick(e) {
        if (!this._maskValue) {
            return;
        }
        const el = e.target;
        const posStart = 0;
        const posEnd = 0;
        if (el !== null &&
            el.selectionStart !== null &&
            el.selectionStart === el.selectionEnd &&
            el.selectionStart > this._maskService.prefix.length &&
            // eslint-disable-next-line
            e.keyCode !== 38) {
            if (this._maskService.showMaskTyped && !this.keepCharacterPositions) {
                // We are showing the mask in the input
                this._maskService.maskIsShown = this._maskService.showMaskInInput();
                if (el.setSelectionRange &&
                    this._maskService.prefix + this._maskService.maskIsShown === el.value) {
                    // the input ONLY contains the mask, so position the cursor at the start
                    el.focus();
                    el.setSelectionRange(posStart, posEnd);
                }
                else {
                    // the input contains some characters already
                    if (el.selectionStart > this._maskService.actualValue.length) {
                        // if the user clicked beyond our value's length, position the cursor at the end of our value
                        el.setSelectionRange(this._maskService.actualValue.length, this._maskService.actualValue.length);
                    }
                }
            }
        }
        const nextValue = el &&
            (el.value === this._maskService.prefix
                ? this._maskService.prefix + this._maskService.maskIsShown
                : el.value);
        /** Fix of cursor position jumping to end in most browsers no matter where cursor is inserted onFocus */
        if (el && el.value !== nextValue) {
            el.value = nextValue;
        }
        /** fix of cursor position with prefix when mouse click occur */
        if (el &&
            el.type !== 'number' &&
            (el.selectionStart || el.selectionEnd) <=
                this._maskService.prefix.length) {
            el.selectionStart = this._maskService.prefix.length;
            return;
        }
        /** select only inserted text */
        if (el && el.selectionEnd > this._getActualInputLength()) {
            el.selectionEnd = this._getActualInputLength();
        }
    }
    // eslint-disable-next-line complexity
    onKeyDown(e) {
        if (!this._maskValue) {
            return;
        }
        if (this._isComposing) {
            // User finalize their choice from IME composition, so trigger onInput() for the composed text.
            if (e.key === 'Enter')
                this.onCompositionEnd(e);
            return;
        }
        this._code = e.code ? e.code : e.key;
        const el = e.target;
        this._inputValue = el.value;
        this._setMask();
        if (el.type !== 'number') {
            if (e.key === "ArrowUp" /* ARROW_UP */) {
                e.preventDefault();
            }
            if (e.key === "ArrowLeft" /* ARROW_LEFT */ ||
                e.key === "Backspace" /* BACKSPACE */ ||
                e.key === "Delete" /* DELETE */) {
                if (e.key === "Backspace" /* BACKSPACE */ && el.value.length === 0) {
                    el.selectionStart = el.selectionEnd;
                }
                if (e.key === "Backspace" /* BACKSPACE */ && el.selectionStart !== 0) {
                    // If specialChars is false, (shouldn't ever happen) then set to the defaults
                    this.specialCharacters = this.specialCharacters?.length
                        ? this.specialCharacters
                        : this._config.specialCharacters;
                    if (this.prefix.length > 1 &&
                        el.selectionStart <= this.prefix.length) {
                        el.setSelectionRange(this.prefix.length, el.selectionEnd);
                    }
                    else {
                        if (this._inputValue.length !== el.selectionStart &&
                            el.selectionStart !== 1) {
                            while (this.specialCharacters.includes((this._inputValue[el.selectionStart - 1] ??
                                "" /* EMPTY_STRING */).toString()) &&
                                ((this.prefix.length >= 1 &&
                                    el.selectionStart > this.prefix.length) ||
                                    this.prefix.length === 0)) {
                                el.setSelectionRange(el.selectionStart - 1, el.selectionEnd);
                            }
                        }
                    }
                }
                this.checkSelectionOnDeletion(el);
                if (this._maskService.prefix.length &&
                    el.selectionStart <= this._maskService.prefix.length &&
                    el.selectionEnd <= this._maskService.prefix.length) {
                    e.preventDefault();
                }
                const cursorStart = el.selectionStart;
                if (e.key === "Backspace" /* BACKSPACE */ &&
                    !el.readOnly &&
                    cursorStart === 0 &&
                    el.selectionEnd === el.value.length &&
                    el.value.length !== 0) {
                    this._position = this._maskService.prefix ? this._maskService.prefix.length : 0;
                    this._maskService.applyMask(this._maskService.prefix, this._maskService.maskExpression, this._position);
                }
            }
            if (!!this.suffix &&
                this.suffix.length > 1 &&
                this._inputValue.length - this.suffix.length < el.selectionStart) {
                el.setSelectionRange(this._inputValue.length - this.suffix.length, this._inputValue.length);
            }
            else if ((e.code === 'KeyA' && e.ctrlKey) ||
                (e.code === 'KeyA' && e.metaKey) // Cmd + A (Mac)
            ) {
                el.setSelectionRange(0, this._getActualInputLength());
                e.preventDefault();
            }
            this._maskService.selStart = el.selectionStart;
            this._maskService.selEnd = el.selectionEnd;
        }
    }
    /** It writes the value in the input */
    async writeValue(controlValue) {
        if (typeof controlValue === 'object' && controlValue !== null && 'value' in controlValue) {
            if ('disable' in controlValue) {
                this.setDisabledState(Boolean(controlValue.disable));
            }
            // eslint-disable-next-line no-param-reassign
            controlValue = controlValue.value;
        }
        if (controlValue !== null) {
            // eslint-disable-next-line no-param-reassign
            controlValue = this.inputTransformFn
                ? this.inputTransformFn(controlValue)
                : controlValue;
        }
        if (typeof controlValue === 'string' ||
            typeof controlValue === 'number' ||
            controlValue === null ||
            controlValue === undefined) {
            if (controlValue === null || controlValue === undefined || controlValue === '') {
                this._maskService._currentValue = '';
                this._maskService._previousValue = '';
            }
            // eslint-disable-next-line no-param-reassign
            let inputValue = controlValue;
            if (typeof inputValue === 'number' ||
                this._maskValue.startsWith("separator" /* SEPARATOR */)) {
                // eslint-disable-next-line no-param-reassign
                inputValue = String(inputValue);
                const localeDecimalMarker = this._maskService.currentLocaleDecimalMarker();
                if (!Array.isArray(this._maskService.decimalMarker)) {
                    // eslint-disable-next-line no-param-reassign
                    inputValue =
                        this._maskService.decimalMarker !== localeDecimalMarker
                            ? inputValue.replace(localeDecimalMarker, this._maskService.decimalMarker)
                            : inputValue;
                }
                if (this._maskService.leadZero &&
                    inputValue &&
                    this.maskExpression &&
                    this.dropSpecialCharacters !== false) {
                    // eslint-disable-next-line no-param-reassign
                    inputValue = this._maskService._checkPrecision(this._maskService.maskExpression, inputValue);
                }
                if (this._maskService.decimalMarker === "," /* COMMA */) {
                    // eslint-disable-next-line no-param-reassign
                    inputValue = inputValue
                        .toString()
                        .replace("." /* DOT */, "," /* COMMA */);
                }
                if (this.maskExpression?.startsWith("separator" /* SEPARATOR */) && this.leadZero) {
                    requestAnimationFrame(() => {
                        this._maskService.applyMask(inputValue?.toString() ?? '', this._maskService.maskExpression);
                    });
                }
                this._maskService.isNumberValue = true;
            }
            if (typeof inputValue !== 'string') {
                // eslint-disable-next-line no-param-reassign
                inputValue = '';
            }
            this._inputValue = inputValue;
            this._setMask();
            if ((inputValue && this._maskService.maskExpression) ||
                (this._maskService.maskExpression &&
                    (this._maskService.prefix || this._maskService.showMaskTyped))) {
                // Let the service we know we are writing value so that triggering onChange function won't happen during applyMask
                typeof this.inputTransformFn !== 'function'
                    ? (this._maskService.writingValue = true)
                    : '';
                this._maskService.formElementProperty = [
                    'value',
                    this._maskService.applyMask(inputValue, this._maskService.maskExpression),
                ];
                // Let the service know we've finished writing value
                typeof this.inputTransformFn !== 'function'
                    ? (this._maskService.writingValue = false)
                    : '';
            }
            else {
                this._maskService.formElementProperty = ['value', inputValue];
            }
            this._inputValue = inputValue;
        }
        else {
            console.warn('Ngx-mask writeValue work with string | number, your current value:', typeof controlValue);
        }
    }
    registerOnChange(fn) {
        this._maskService.onChange = this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouch = fn;
    }
    _getActiveElement(document = this.document) {
        const shadowRootEl = document?.activeElement?.shadowRoot;
        if (!shadowRootEl?.activeElement) {
            return document.activeElement;
        }
        else {
            return this._getActiveElement(shadowRootEl);
        }
    }
    checkSelectionOnDeletion(el) {
        el.selectionStart = Math.min(Math.max(this.prefix.length, el.selectionStart), this._inputValue.length - this.suffix.length);
        el.selectionEnd = Math.min(Math.max(this.prefix.length, el.selectionEnd), this._inputValue.length - this.suffix.length);
    }
    /** It disables the input element */
    setDisabledState(isDisabled) {
        this._maskService.formElementProperty = ['disabled', isDisabled];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    _applyMask() {
        this._maskService.maskExpression = this._maskService._repeatPatternSymbols(this._maskValue || '');
        this._maskService.formElementProperty = [
            'value',
            this._maskService.applyMask(this._inputValue, this._maskService.maskExpression),
        ];
    }
    _validateTime(value) {
        const rowMaskLen = this._maskValue
            .split("" /* EMPTY_STRING */)
            .filter((s) => s !== ':').length;
        if (!value) {
            return null; // Don't validate empty values to allow for optional form control
        }
        if ((+(value[value.length - 1] ?? -1) === 0 && value.length < rowMaskLen) ||
            value.length <= rowMaskLen - 2) {
            return this._createValidationError(value);
        }
        return null;
    }
    _getActualInputLength() {
        return (this._maskService.actualValue.length ||
            this._maskService.actualValue.length + this._maskService.prefix.length);
    }
    _createValidationError(actualValue) {
        return {
            mask: {
                requiredMask: this._maskValue,
                actualValue,
            },
        };
    }
    _setMask() {
        this._maskExpressionArray.some((mask) => {
            const specialChart = mask
                .split("" /* EMPTY_STRING */)
                .some((char) => this._maskService.specialCharacters.includes(char));
            if ((specialChart && this._inputValue && !mask.includes("S" /* LETTER_S */)) ||
                mask.includes("{" /* CURLY_BRACKETS_LEFT */)) {
                const test = this._maskService.removeMask(this._inputValue)?.length <=
                    this._maskService.removeMask(mask)?.length;
                if (test) {
                    this._maskValue =
                        this.maskExpression =
                            this._maskService.maskExpression =
                                mask.includes("{" /* CURLY_BRACKETS_LEFT */)
                                    ? this._maskService._repeatPatternSymbols(mask)
                                    : mask;
                    return test;
                }
                else {
                    const expression = this._maskExpressionArray[this._maskExpressionArray.length - 1] ??
                        "" /* EMPTY_STRING */;
                    this._maskValue =
                        this.maskExpression =
                            this._maskService.maskExpression =
                                expression.includes("{" /* CURLY_BRACKETS_LEFT */)
                                    ? this._maskService._repeatPatternSymbols(expression)
                                    : expression;
                }
            }
            else {
                const check = this._maskService
                    .removeMask(this._inputValue)
                    ?.split("" /* EMPTY_STRING */)
                    .every((character, index) => {
                    const indexMask = mask.charAt(index);
                    return this._maskService._checkSymbolMask(character, indexMask);
                });
                if (check) {
                    this._maskValue = this.maskExpression = this._maskService.maskExpression = mask;
                    return check;
                }
            }
        });
    }
}
NgxMaskDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskDirective, deps: [{ token: DOCUMENT }, { token: NGX_MASK_CONFIG }, { token: i1.NgxMaskService }], target: i0.ɵɵFactoryTarget.Directive });
NgxMaskDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.3.12", type: NgxMaskDirective, selector: "input[mask], textarea[mask]", inputs: { maskExpression: ["mask", "maskExpression"], specialCharacters: "specialCharacters", patterns: "patterns", prefix: "prefix", suffix: "suffix", thousandSeparator: "thousandSeparator", decimalMarker: "decimalMarker", dropSpecialCharacters: "dropSpecialCharacters", hiddenInput: "hiddenInput", showMaskTyped: "showMaskTyped", placeHolderCharacter: "placeHolderCharacter", shownMaskExpression: "shownMaskExpression", showTemplate: "showTemplate", clearIfNotMatch: "clearIfNotMatch", validation: "validation", separatorLimit: "separatorLimit", allowNegativeNumbers: "allowNegativeNumbers", leadZeroDateTime: "leadZeroDateTime", leadZero: "leadZero", triggerOnMaskChange: "triggerOnMaskChange", apm: "apm", inputTransformFn: "inputTransformFn", outputTransformFn: "outputTransformFn", keepCharacterPositions: "keepCharacterPositions" }, outputs: { maskFilled: "maskFilled" }, host: { listeners: { "paste": "onPaste()", "focus": "onFocus($event)", "ngModelChange": "onModelChange($event)", "input": "onInput($event)", "compositionstart": "onCompositionStart($event)", "compositionend": "onCompositionEnd($event)", "blur": "onBlur($event)", "click": "onClick($event)", "keydown": "onKeyDown($event)" } }, providers: [
        {
            provide: NG_VALUE_ACCESSOR,
            useExisting: forwardRef(() => NgxMaskDirective),
            multi: true,
        },
        {
            provide: NG_VALIDATORS,
            useExisting: forwardRef(() => NgxMaskDirective),
            multi: true,
        },
        NgxMaskService,
    ], exportAs: ["mask", "ngxMask"], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'input[mask], textarea[mask]',
                    providers: [
                        {
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: forwardRef(() => NgxMaskDirective),
                            multi: true,
                        },
                        {
                            provide: NG_VALIDATORS,
                            useExisting: forwardRef(() => NgxMaskDirective),
                            multi: true,
                        },
                        NgxMaskService,
                    ],
                    exportAs: 'mask,ngxMask',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [NGX_MASK_CONFIG]
                }] }, { type: i1.NgxMaskService }]; }, propDecorators: { maskExpression: [{
                type: Input,
                args: ['mask']
            }], specialCharacters: [{
                type: Input
            }], patterns: [{
                type: Input
            }], prefix: [{
                type: Input
            }], suffix: [{
                type: Input
            }], thousandSeparator: [{
                type: Input
            }], decimalMarker: [{
                type: Input
            }], dropSpecialCharacters: [{
                type: Input
            }], hiddenInput: [{
                type: Input
            }], showMaskTyped: [{
                type: Input
            }], placeHolderCharacter: [{
                type: Input
            }], shownMaskExpression: [{
                type: Input
            }], showTemplate: [{
                type: Input
            }], clearIfNotMatch: [{
                type: Input
            }], validation: [{
                type: Input
            }], separatorLimit: [{
                type: Input
            }], allowNegativeNumbers: [{
                type: Input
            }], leadZeroDateTime: [{
                type: Input
            }], leadZero: [{
                type: Input
            }], triggerOnMaskChange: [{
                type: Input
            }], apm: [{
                type: Input
            }], inputTransformFn: [{
                type: Input
            }], outputTransformFn: [{
                type: Input
            }], keepCharacterPositions: [{
                type: Input
            }], maskFilled: [{
                type: Output
            }], onPaste: [{
                type: HostListener,
                args: ['paste']
            }], onFocus: [{
                type: HostListener,
                args: ['focus', ['$event']]
            }], onModelChange: [{
                type: HostListener,
                args: ['ngModelChange', ['$event']]
            }], onInput: [{
                type: HostListener,
                args: ['input', ['$event']]
            }], onCompositionStart: [{
                type: HostListener,
                args: ['compositionstart', ['$event']]
            }], onCompositionEnd: [{
                type: HostListener,
                args: ['compositionend', ['$event']]
            }], onBlur: [{
                type: HostListener,
                args: ['blur', ['$event']]
            }], onClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }], onKeyDown: [{
                type: HostListener,
                args: ['keydown', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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