import { NgModule } from '@angular/core';
import { NGX_MASK_CONFIG, INITIAL_CONFIG, initialConfig, NEW_CONFIG, } from './ngx-mask.config';
import { NgxMaskDirective } from './ngx-mask.directive';
import { NgxMaskPipe } from './ngx-mask.pipe';
import { NgxMaskService } from './ngx-mask.service';
import * as i0 from "@angular/core";
/**
 * @internal
 */
export function _configFactory(initConfig, configValue) {
    return configValue instanceof Function
        ? { ...initConfig, ...configValue() }
        : { ...initConfig, ...configValue };
}
export class NgxMaskModule {
    static forRoot(configValue) {
        return {
            ngModule: NgxMaskModule,
            providers: [
                {
                    provide: NEW_CONFIG,
                    useValue: configValue,
                },
                {
                    provide: INITIAL_CONFIG,
                    useValue: initialConfig,
                },
                {
                    provide: NGX_MASK_CONFIG,
                    useFactory: _configFactory,
                    deps: [INITIAL_CONFIG, NEW_CONFIG],
                },
                NgxMaskService,
            ],
        };
    }
    static forChild() {
        return {
            ngModule: NgxMaskModule,
        };
    }
}
NgxMaskModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
NgxMaskModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskModule, declarations: [NgxMaskDirective, NgxMaskPipe], exports: [NgxMaskDirective, NgxMaskPipe] });
NgxMaskModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskModule });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskModule, decorators: [{
            type: NgModule,
            args: [{
                    exports: [NgxMaskDirective, NgxMaskPipe],
                    declarations: [NgxMaskDirective, NgxMaskPipe],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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