import { Pipe } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./ngx-mask.service";
export class NgxMaskPipe {
    constructor(_maskService) {
        this._maskService = _maskService;
        this.defaultOptions = {};
        this._maskExpressionArray = [];
        this.mask = '';
    }
    transform(value, mask, { patterns, ...config } = {}) {
        const currentConfig = {
            maskExpression: mask,
            ...this.defaultOptions,
            ...config,
            patterns: {
                ...this._maskService.patterns,
                ...patterns,
            },
        };
        Object.entries(currentConfig).forEach(([key, value]) => {
            //eslint-disable-next-line  @typescript-eslint/no-explicit-any
            this._maskService[key] = value;
        });
        if (mask.includes('||')) {
            if (mask.split('||').length > 1) {
                this._maskExpressionArray = mask.split('||').sort((a, b) => {
                    return a.length - b.length;
                });
                this._setMask(value);
                return this._maskService.applyMask(`${value}`, this.mask);
            }
            else {
                this._maskExpressionArray = [];
                return this._maskService.applyMask(`${value}`, this.mask);
            }
        }
        if (mask.includes("{" /* CURLY_BRACKETS_LEFT */)) {
            return this._maskService.applyMask(`${value}`, this._maskService._repeatPatternSymbols(mask));
        }
        if (mask.startsWith("separator" /* SEPARATOR */)) {
            if (config.decimalMarker) {
                this._maskService.decimalMarker = config.decimalMarker;
            }
            if (config.thousandSeparator) {
                this._maskService.thousandSeparator = config.thousandSeparator;
            }
            if (config.leadZero) {
                // eslint-disable-next-line no-param-reassign
                this._maskService.leadZero = config.leadZero;
            }
            // eslint-disable-next-line no-param-reassign
            value = String(value);
            const localeDecimalMarker = this._maskService.currentLocaleDecimalMarker();
            if (!Array.isArray(this._maskService.decimalMarker)) {
                // eslint-disable-next-line no-param-reassign
                value =
                    this._maskService.decimalMarker !== localeDecimalMarker
                        ? value.replace(localeDecimalMarker, this._maskService.decimalMarker)
                        : value;
            }
            if (this._maskService.leadZero &&
                value &&
                this._maskService.dropSpecialCharacters !== false) {
                // eslint-disable-next-line no-param-reassign
                value = this._maskService._checkPrecision(mask, value);
            }
            if (this._maskService.decimalMarker === "," /* COMMA */) {
                // eslint-disable-next-line no-param-reassign
                value = value.toString().replace("." /* DOT */, "," /* COMMA */);
            }
            this._maskService.isNumberValue = true;
        }
        if (value === null || value === undefined) {
            return this._maskService.applyMask('', mask);
        }
        return this._maskService.applyMask(`${value}`, mask);
    }
    _setMask(value) {
        if (this._maskExpressionArray.length > 0) {
            this._maskExpressionArray.some((mask) => {
                const test = this._maskService.removeMask(value)?.length <=
                    this._maskService.removeMask(mask)?.length;
                if (value && test) {
                    this.mask = mask;
                    return test;
                }
                else {
                    const expression = this._maskExpressionArray[this._maskExpressionArray.length - 1] ??
                        "" /* EMPTY_STRING */;
                    this.mask = expression;
                }
            });
        }
    }
}
NgxMaskPipe.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskPipe, deps: [{ token: i1.NgxMaskService }], target: i0.ɵɵFactoryTarget.Pipe });
NgxMaskPipe.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskPipe, name: "mask" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgxMaskPipe, decorators: [{
            type: Pipe,
            args: [{
                    name: 'mask',
                    pure: true,
                }]
        }], ctorParameters: function () { return [{ type: i1.NgxMaskService }]; } });
//# sourceMappingURL=data:application/json;base64,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