import { OnChanges, SimpleChanges } from '@angular/core';
import { ControlValueAccessor, FormControl, ValidationErrors, Validator } from '@angular/forms';
import { CustomKeyboardEvent } from './custom-keyboard-event';
import { IConfig } from './ngx-mask.config';
import { NgxMaskService } from './ngx-mask.service';
import * as i0 from "@angular/core";
interface IOnChage {
    (_: any): void;
}
interface IOnTouch {
    (): void;
}
export declare class NgxMaskDirective implements ControlValueAccessor, OnChanges, Validator {
    private document;
    protected _config: IConfig;
    _maskService: NgxMaskService;
    maskExpression: string | undefined | null;
    specialCharacters: IConfig['specialCharacters'];
    patterns: IConfig['patterns'];
    prefix: IConfig['prefix'];
    suffix: IConfig['suffix'];
    thousandSeparator: IConfig['thousandSeparator'];
    decimalMarker: IConfig['decimalMarker'];
    dropSpecialCharacters: IConfig['dropSpecialCharacters'] | null;
    hiddenInput: IConfig['hiddenInput'] | null;
    showMaskTyped: IConfig['showMaskTyped'] | null;
    placeHolderCharacter: IConfig['placeHolderCharacter'] | null;
    shownMaskExpression: IConfig['shownMaskExpression'] | null;
    showTemplate: IConfig['showTemplate'] | null;
    clearIfNotMatch: IConfig['clearIfNotMatch'] | null;
    validation: IConfig['validation'] | null;
    separatorLimit: IConfig['separatorLimit'] | null;
    allowNegativeNumbers: IConfig['allowNegativeNumbers'] | null;
    leadZeroDateTime: IConfig['leadZeroDateTime'] | null;
    leadZero: IConfig['leadZero'] | null;
    triggerOnMaskChange: IConfig['triggerOnMaskChange'] | null;
    apm: IConfig['apm'] | null;
    inputTransformFn: IConfig['inputTransformFn'] | null;
    outputTransformFn: IConfig['outputTransformFn'] | null;
    keepCharacterPositions: IConfig['keepCharacterPositions'] | null;
    maskFilled: IConfig['maskFilled'];
    private _maskValue;
    private _isFocused;
    private _inputValue;
    private _position;
    private _code;
    private _maskExpressionArray;
    private _justPasted;
    /**For IME composition event */
    private _isComposing;
    constructor(document: any, _config: IConfig, _maskService: NgxMaskService);
    onChange: IOnChage;
    onTouch: IOnTouch;
    ngOnChanges(changes: SimpleChanges): void;
    validate({ value }: FormControl): ValidationErrors | null;
    onPaste(): void;
    onFocus(): void;
    onModelChange(value: string | undefined | null | number): void;
    onInput(e: CustomKeyboardEvent): void;
    onCompositionStart(): void;
    onCompositionEnd(e: CustomKeyboardEvent): void;
    onBlur(e: CustomKeyboardEvent): void;
    onClick(e: MouseEvent | CustomKeyboardEvent): void;
    onKeyDown(e: CustomKeyboardEvent): void;
    /** It writes the value in the input */
    writeValue(controlValue: string | number | {
        value: string | number;
        disable?: boolean;
    }): Promise<void>;
    registerOnChange(fn: IOnChage): void;
    registerOnTouched(fn: IOnTouch): void;
    private _getActiveElement;
    checkSelectionOnDeletion(el: HTMLInputElement): void;
    /** It disables the input element */
    setDisabledState(isDisabled: boolean): void;
    private _applyMask;
    private _validateTime;
    private _getActualInputLength;
    private _createValidationError;
    private _setMask;
    static ɵfac: i0.ɵɵFactoryDeclaration<NgxMaskDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<NgxMaskDirective, "input[mask], textarea[mask]", ["mask", "ngxMask"], { "maskExpression": "mask"; "specialCharacters": "specialCharacters"; "patterns": "patterns"; "prefix": "prefix"; "suffix": "suffix"; "thousandSeparator": "thousandSeparator"; "decimalMarker": "decimalMarker"; "dropSpecialCharacters": "dropSpecialCharacters"; "hiddenInput": "hiddenInput"; "showMaskTyped": "showMaskTyped"; "placeHolderCharacter": "placeHolderCharacter"; "shownMaskExpression": "shownMaskExpression"; "showTemplate": "showTemplate"; "clearIfNotMatch": "clearIfNotMatch"; "validation": "validation"; "separatorLimit": "separatorLimit"; "allowNegativeNumbers": "allowNegativeNumbers"; "leadZeroDateTime": "leadZeroDateTime"; "leadZero": "leadZero"; "triggerOnMaskChange": "triggerOnMaskChange"; "apm": "apm"; "inputTransformFn": "inputTransformFn"; "outputTransformFn": "outputTransformFn"; "keepCharacterPositions": "keepCharacterPositions"; }, { "maskFilled": "maskFilled"; }, never>;
}
export {};
