import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

import { AppComponent } from './app.component';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { ReactiveFormsModule } from '@angular/forms';
import { MagicModule, MagicLazyLoaderService } from '@magic-xpa/angular';
import { MagicAngularMaterialModule } from '@magic-xpa/angular-material-core';
import { MagicGenLibModule } from './magic/magic.gen.lib.module';
import { MagicRoutingModule } from './app.routes';
import { LazyLoaderService } from './magic/lazy-loader.service';
import { XpacoreuiModule } from './xpacoreui.module';
import { SmartuxXpaBridgeModule } from "@smartux/xpa-bridge";
import { getProvider } from "@smartux/xpa-bridge";


import {
  PERFECT_SCROLLBAR_CONFIG,
  PerfectScrollbarConfigInterface,
  PerfectScrollbarModule,
} from 'ngx-perfect-scrollbar';
import { EngineMagicService } from "@magic-xpa/angular";
import { EngineLivePreviewMagicService } from "@smartux/xpa-bridge";
import { MatFormFieldModule } from "@angular/material/form-field";
import { MatSelectModule } from "@angular/material/select";
import { MatPaginatorModule } from "@angular/material/paginator";
import { MatListModule } from "@angular/material/list";
import { MatInputModule } from "@angular/material/input";
import { MatRadioModule } from "@angular/material/radio";
import { MatDatepickerModule } from "@angular/material/datepicker";
import { MatSortModule } from "@angular/material/sort";
import { MatTableModule } from "@angular/material/table";
import { MatCheckboxModule } from "@angular/material/checkbox";
import { MatDialogModule } from "@angular/material/dialog";
import { MatCardModule } from "@angular/material/card";
import { MatNativeDateModule } from "@angular/material/core";
import { MatTabsModule } from "@angular/material/tabs";
import { MatTooltipModule } from "@angular/material/tooltip";
import { MatButtonModule } from "@angular/material/button";
import { MatToolbarModule } from "@angular/material/toolbar";
import { MatSidenavModule } from "@angular/material/sidenav";
import { MatIconModule } from "@angular/material/icon";
import { MatGridListModule } from "@angular/material/grid-list";

const DEFAULT_PERFECT_SCROLLBAR_CONFIG: PerfectScrollbarConfigInterface = {
  suppressScrollX: true,
};


@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [ MatFormFieldModule,
  MatSelectModule,
  MatPaginatorModule,
  MatListModule,
  MatInputModule,
  MatRadioModule,
  MatDatepickerModule,
  MatSortModule,
  MatTableModule,
  MatCheckboxModule,
  MatDialogModule,
  MatCardModule,
  MatNativeDateModule,
  MatTabsModule,
  MatTooltipModule,
  MatButtonModule,
  MatToolbarModule,
  MatSidenavModule,
  MatIconModule,
  MatGridListModule,
  BrowserModule,
  BrowserAnimationsModule,
  ReactiveFormsModule,
  MagicModule,
  MagicAngularMaterialModule,
  MagicGenLibModule,
  MagicRoutingModule,
  XpacoreuiModule,
  SmartuxXpaBridgeModule,
  PerfectScrollbarModule ],
  providers: [ getProvider(),
  { provide: MagicLazyLoaderService, useClass: LazyLoaderService },
  {      provide: PERFECT_SCROLLBAR_CONFIG,      useValue: DEFAULT_PERFECT_SCROLLBAR_CONFIG,    },
  { provide: EngineMagicService, useClass: EngineLivePreviewMagicService } ],
  bootstrap: [AppComponent]
})
export class AppModule { }
