import {
    FormControl,
    FormGroup
} from "@angular/forms";
import {
    MagicServices
} from "@magic-xpa/angular";
export enum MgControlName {
    WebClientShouhinMaster = "WebClientShouhinMaster",
        Table1 = "Table1",
        Column5 = "Column5",
        ShouhinMaster_ShouhinCode = "ShouhinMaster_ShouhinCode",
        Column6 = "Column6",
        ShouhinMaster_ShouhinName = "ShouhinMaster_ShouhinName",
        Column7 = "Column7",
        ShouhinMaster_Tanka = "ShouhinMaster_Tanka",
}
export enum MgCustomProperties {}
export var
    MgDisplayedColumns = [
        'Column5',
        'Column6',
        'Column7',
    ];

export class MgFormControlsAccessor {
    constructor(private fg: FormGroup, private magicServices: MagicServices) {}

    get ShouhinMaster_ShouhinCode(): FormControl {
        return this.getTableChildFormControl(MgControlName.ShouhinMaster_ShouhinCode);
    }

    get ShouhinMaster_ShouhinName(): FormControl {
        return this.getTableChildFormControl(MgControlName.ShouhinMaster_ShouhinName);
    }

    get ShouhinMaster_Tanka(): FormControl {
        return this.getTableChildFormControl(MgControlName.ShouhinMaster_Tanka);
    }

    getTableChildFormControl(name: MgControlName): FormControl {
        return this.magicServices.mgAccessorService.getFormGroupByRow(this.magicServices.tableService.getSelectedRow()).controls[name] as FormControl;
    }
}