import {NgModule, NgModuleRef} from '@angular/core';
import {RouterModule} from '@angular/router';
import {ReactiveFormsModule} from '@angular/forms';
import {CommonModule} from "@angular/common";


import {DynamicModule} from 'ng-dynamic-component';
import {InfiniteScrollModule} from 'ngx-infinite-scroll';

import {ComponentListMagicService, MagicModule, ExitMagicService} from "@magic-xpa/angular";
import {magicGenComponents, magicGenCmpsHash, title, LazyLoadModulesMap} from './component-list.g';
import {MagicAngularMaterialModule} from "@magic-xpa/angular-material-core";
import {MatFormFieldModule} from "@angular/material/form-field";
import {MatSelectModule} from "@angular/material/select";
import {MatPaginatorModule} from "@angular/material/paginator";
import {MatListModule} from "@angular/material/list";
import {MatInputModule} from "@angular/material/input";
import {MatRadioModule} from "@angular/material/radio";
import {MatDatepickerModule} from "@angular/material/datepicker";
import {MatSortModule} from "@angular/material/sort";
import {MatTableModule} from "@angular/material/table";
import {MatCheckboxModule} from "@angular/material/checkbox";
import {MatCardModule} from "@angular/material/card";
import {MatNativeDateModule} from "@angular/material/core";
import {MatTabsModule} from "@angular/material/tabs";
import {MatTooltipModule} from "@angular/material/tooltip";
import {MatButtonModule} from "@angular/material/button";
import {MatAutocompleteModule} from "@angular/material/autocomplete";
import {CurrencyMaskConfig, CurrencyMaskInputMode, NgxCurrencyModule} from "ngx-currency";
import { NgxMaskModule, IConfig } from "ngx-mask";
import { XpacoreuiModule } from '../xpacoreui.module';

import {
  PERFECT_SCROLLBAR_CONFIG,
  PerfectScrollbarConfigInterface,
  PerfectScrollbarModule,
} from 'ngx-perfect-scrollbar';
import { DefaultHeaderComponent } from './mainWC/StartProgram/default-header/default-header.component';
import { DefaultFooterComponent } from './mainWC/StartProgram/default-footer/default-footer.component';
import { MatDialogModule } from "@angular/material/dialog";
import { MatToolbarModule } from "@angular/material/toolbar";
import { MatSidenavModule } from "@angular/material/sidenav";
import { MatIconModule } from "@angular/material/icon";
import { MatGridListModule } from "@angular/material/grid-list";

// Shared Newalert and Newcnf
import { AlertDialogComponent } from '../shared/components/alert-dialog/alert-dialog.component';
import { ConfirmationDialogComponent } from '../shared/components/confirmation-dialog/confirmation-dialog.component';
import { ConfirmationComponentsMagicProvider } from "@magic-xpa/angular";
import { MyConfirmationMagicProviderService } from "./my-confirmation-magic-provider.service";

const DEFAULT_PERFECT_SCROLLBAR_CONFIG: PerfectScrollbarConfigInterface = {
  suppressScrollX: true,
};


export const options: Partial<IConfig> | (() => Partial<IConfig>) = {};

export const customCurrencyMaskConfig: CurrencyMaskConfig = {
  align: "right",
  allowNegative: true,
  allowZero: true,
  decimal: ".",
  precision: 2,
  prefix: "",
  suffix: "",
  thousands: ",",
  nullable: true,
  min: undefined,
  max: undefined,
  inputMode: CurrencyMaskInputMode.FINANCIAL
};

@NgModule({
  declarations: [
    ...magicGenComponents,
    DefaultHeaderComponent,
    DefaultFooterComponent,
    AlertDialogComponent,
    ConfirmationDialogComponent,
  ],
  exports: [
    ...magicGenComponents,
    MagicModule
  ],
  imports: [ MatDialogModule,
  MatToolbarModule,
  MatSidenavModule,
  MatIconModule,
  MatGridListModule,
  RouterModule,
  ReactiveFormsModule,
  CommonModule,
  DynamicModule,
  InfiniteScrollModule,
  MagicModule,
  MagicAngularMaterialModule,
  MatFormFieldModule,
  MatSelectModule,
  MatPaginatorModule,
  MatListModule,
  MatInputModule,
  MatRadioModule,
  MatDatepickerModule,
  MatSortModule,
  MatTableModule,
  MatCheckboxModule,
  MatCardModule,
  MatNativeDateModule,
  MatTabsModule,
  MatTooltipModule,
  MatButtonModule,
  MatAutocompleteModule,
  NgxCurrencyModule.forRoot(customCurrencyMaskConfig),
  NgxCurrencyModule.forRoot(customCurrencyMaskConfig),
  NgxMaskModule.forRoot(),
  XpacoreuiModule,
  PerfectScrollbarModule ],
  providers: [
     ExitMagicService ,
    {
      provide: PERFECT_SCROLLBAR_CONFIG,
      useValue: DEFAULT_PERFECT_SCROLLBAR_CONFIG,
    },
    {
      provide: ConfirmationComponentsMagicProvider,
      useClass: MyConfirmationMagicProviderService
    }
  ],
})
export class MagicGenLibModule {
  constructor(componentList: ComponentListMagicService, private moduleRef: NgModuleRef<any>) {
    componentList.addComponents(magicGenCmpsHash, moduleRef);
    componentList.title = title; 
    componentList.lazyLoadModulesMap = LazyLoadModulesMap; 
    componentList.lazyLoadModulesMap = LazyLoadModulesMap; 
    componentList.lazyLoadModulesMap = LazyLoadModulesMap;   
  }
}
