import { Component } from '@angular/core';

import { FormGroup } from "@angular/forms";
import { MgFormControlsAccessor, MgControlName, MgCustomProperties } from "./StartProgram.mg.controls.g";


import { TaskBaseMagicComponent, magicProviders } from "@magic-xpa/angular";
import { INavData } from '@coreui/angular';


@Component({
  selector: 'mga-StartProgram',
  providers: [...magicProviders],
  templateUrl: './StartProgram.component.html'
})
export class StartProgram extends TaskBaseMagicComponent {

  mgc = MgControlName;
  mgcp = MgCustomProperties;
  mgfc!: MgFormControlsAccessor;
  override createFormControlsAccessor(formGroup: FormGroup) {
    this.mgfc = new MgFormControlsAccessor(formGroup, this.magicServices);
  }

  public navItems: INavData[] = [];
  
  override PropertyChanged(propertyName: string, rowID: number, propertyValue: any): void {
    if (propertyName == this.mgcp.StartProgram_menuData) {
      if (this.mg.getCustomProperty(this.mgcp.StartProgram_menuData) !== null) {
        this.navItems = getMenu(this.mg.getCustomProperty(this.mgcp.StartProgram_menuData));
      }
    }
  }

  public perfectScrollbarConfig = {
    suppressScrollX: true,
  }
}

function getMenu(menuData: string): INavData[] {
    return JSON.parse(menuData);
}