import {
    FormControl,
    FormGroup
} from "@angular/forms";
import {
    MagicServices
} from "@magic-xpa/angular";
export enum MgControlName {
    UserDropdown = "UserDropdown",
        numberOfUpdates = "numberOfUpdates",
        userImage = "userImage",
        numberOfMessages = "numberOfMessages",
        btnSettings = "btnSettings",
        btnLogOut = "btnLogOut",
}
export enum MgCustomProperties {}
export class MgFormControlsAccessor {
    constructor(private fg: FormGroup, private magicServices: MagicServices) {}

    getTableChildFormControl(name: MgControlName): FormControl {
        return this.magicServices.mgAccessorService.getFormGroupByRow(this.magicServices.tableService.getSelectedRow()).controls[name] as FormControl;
    }
}