import { Component } from '@angular/core';

import { FormGroup } from "@angular/forms";
import { MgFormControlsAccessor, MgControlName, MgCustomProperties } from "./Welcome.mg.controls.g";


import { TaskBaseMagicComponent, magicProviders } from "@magic-xpa/angular";


@Component({
    selector: 'mga-Welcome',
    providers: [...magicProviders],
    templateUrl: './Welcome.component.html',
    styleUrls: ['./Welcome.component.scss'],
})
export class Welcome extends TaskBaseMagicComponent {

    mgc = MgControlName;
    mgcp = MgCustomProperties;
    mgfc!: MgFormControlsAccessor;
    override createFormControlsAccessor(formGroup: FormGroup) {
        this.mgfc = new MgFormControlsAccessor(formGroup, this.magicServices);
    }

    cardDetails = [
        {
            imgURL: "https://www.magicsoftware.com/wp-content/uploads/2018/08/endless-icon-white-fixed-height-33.png",
            cardTitle: "Magic + Angular",
            cardDesc: " By working with Magic xpa to develop your Angular apps, you benefit from the best of both worlds: you define the business logic in Magic and develop the presentation using Angular code."
        },
        {
            imgURL: "https://www.magicsoftware.com/wp-content/uploads/2018/08/app_1-icon-white.png",
            cardTitle: "Great UX/UI",
            cardDesc: "  Easily create intuitive and modern screens for your apps without having to design the screens yourselves. Let Web designers handle the screens, freeing you up to do what you do best."
        },
        {
            imgURL: "https://www.magicsoftware.com/wp-content/uploads/2018/08/code-icon-white.png",
            cardTitle: "Large-Scale Apps",
            cardDesc: "Large-scale apps that Angular has a hard time handling, are not a problem when working with Magic's Web application framework. Even an SPA app with thousands of screens is easy with Magic."
        }
    ]
}

