import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { BrowserModule, Title } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { IconModule, IconSetService } from '@coreui/icons-angular';



import {
  AvatarModule,
  BadgeModule,
  BreadcrumbModule,
  ButtonGroupModule,
  ButtonModule,
  CardModule,
  DropdownModule,
  FooterModule,
  FormModule,
  GridModule,
  HeaderModule,
  ListGroupModule,
  NavModule,
  ProgressModule,
  SharedModule,
  SidebarModule,
  TabsModule,
  UtilitiesModule,
  AccordionModule
} from '@coreui/angular';
import { MagicAngularMaterialModule } from "@magic-xpa/angular-material-core";
import { MatFormFieldModule } from "@angular/material/form-field";
import { MatSelectModule } from "@angular/material/select";
import { MatPaginatorModule } from "@angular/material/paginator";
import { MatListModule } from "@angular/material/list";
import { MatInputModule } from "@angular/material/input";
import { MatRadioModule } from "@angular/material/radio";
import { MatDatepickerModule } from "@angular/material/datepicker";
import { MatSortModule } from "@angular/material/sort";
import { MatTableModule } from "@angular/material/table";
import { MatCheckboxModule } from "@angular/material/checkbox";
import { MatDialogModule } from "@angular/material/dialog";
import { MatCardModule } from "@angular/material/card";
import { MatNativeDateModule } from "@angular/material/core";
import { MatTabsModule } from "@angular/material/tabs";
import { MatTooltipModule } from "@angular/material/tooltip";
import { MatButtonModule } from "@angular/material/button";
import { MatToolbarModule } from "@angular/material/toolbar";
import { MatSidenavModule } from "@angular/material/sidenav";
import { MatIconModule } from "@angular/material/icon";
import { MatGridListModule } from "@angular/material/grid-list";

const coreUiModules = [
  CommonModule,
  AvatarModule,
  BrowserModule,
  BrowserAnimationsModule,
  BreadcrumbModule,
  FooterModule,
  DropdownModule,
  GridModule,
  HeaderModule,
  SidebarModule,
  IconModule,
  NavModule,
  ButtonModule,
  FormModule,
  UtilitiesModule,
  ButtonGroupModule,
  SidebarModule,
  SharedModule,
  TabsModule,
  ListGroupModule,
  ProgressModule,
  BadgeModule,
  ListGroupModule,
  CardModule,
  AccordionModule,
]


@NgModule({
  declarations: [],
  imports: [MagicAngularMaterialModule,
    MatFormFieldModule,
    MatSelectModule,
    MatPaginatorModule,
    MatListModule,
    MatInputModule,
    MatRadioModule,
    MatDatepickerModule,
    MatSortModule,
    MatTableModule,
    MatCheckboxModule,
    MatDialogModule,
    MatCardModule,
    MatNativeDateModule,
    MatTabsModule,
    MatTooltipModule,
    MatButtonModule,
    MatToolbarModule,
    MatSidenavModule,
    MatIconModule,
    MatGridListModule],
  providers: [
    IconSetService,
    Title
  ],
  exports: [coreUiModules]
})
export class XpacoreuiModule { }
